/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class Command
implements Dumpable {
    final AtomicBoolean guiEnabled = new AtomicBoolean(false);
    final AtomicBoolean guiForChild = new AtomicBoolean(false);
    final AtomicReference<String> name = new AtomicReference();
    volatile String[] tokens = new String[0];
    final AtomicReference<String> pattern = new AtomicReference();
    final AtomicReference<String> description = new AtomicReference();
    final AtomicBoolean enabled = new AtomicBoolean(false);
    Entity parent;
    transient CommandExecutor commandExecutor;

    public Command(String name, String pattern, String description, boolean enabled, CommandExecutor commandExecutor) {
        this(name, pattern, description, enabled, commandExecutor, false, false);
    }

    public Command(String name, String pattern, String description, boolean enabled, CommandExecutor commandExecutor, boolean guiEnabled, boolean guiForChild) {
        this.name.set(name);
        this.pattern.set(pattern);
        this.description.set(description);
        this.enabled.set(enabled);
        this.commandExecutor = commandExecutor;
        this.guiEnabled.set(guiEnabled);
        this.guiForChild.set(guiForChild);
        this.tokens = SwiftUtilities.tokenize(name, " ");
    }

    Command() {
    }

    @Override
    public int getDumpId() {
        return 7;
    }

    private void writeDump(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    private String readDump(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return in.readUTF();
        }
        return null;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        this.writeDump(out, this.name.get());
        this.writeDump(out, this.pattern.get());
        this.writeDump(out, this.description.get());
        out.writeBoolean(this.enabled.get());
        out.writeBoolean(this.guiEnabled.get());
        out.writeBoolean(this.guiForChild.get());
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.name.set(this.readDump(in));
        this.pattern.set(this.readDump(in));
        this.description.set(this.readDump(in));
        this.enabled.set(in.readBoolean());
        this.guiEnabled.set(in.readBoolean());
        this.guiForChild.set(in.readBoolean());
        this.tokens = SwiftUtilities.tokenize(this.name.get(), " ");
    }

    public String getPattern() {
        return this.pattern.get();
    }

    public String getName() {
        return this.name.get();
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public String getDescription() {
        return this.description.get();
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    public Entity getParent() {
        return this.parent;
    }

    protected void setParent(Entity parent) {
        this.parent = parent;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public boolean isGuiEnabled() {
        return this.guiEnabled.get();
    }

    public void setGuiEnabled(boolean guiEnabled) {
        this.guiEnabled.set(guiEnabled);
    }

    public boolean isGuiForChild() {
        return this.guiForChild.get();
    }

    public void setGuiForChild(boolean guiForChild) {
        this.guiForChild.set(guiForChild);
    }

    public boolean equals(String[] cmd) {
        if (this.tokens.length > cmd.length) {
            return false;
        }
        for (int i = 0; i < this.tokens.length; ++i) {
            if (this.tokens[i].equals(cmd[i])) continue;
            return false;
        }
        return true;
    }

    private String quote(String s) {
        return "\"" + s + "\"";
    }

    public String toJson() {
        StringBuffer s = new StringBuffer();
        s.append("{");
        s.append(this.quote("name")).append(": ");
        s.append(this.quote(this.name.get())).append(", ");
        s.append(this.quote("description")).append(": ");
        s.append(this.quote(this.description.get())).append(", ");
        s.append(this.quote("guiForChild")).append(": ");
        s.append(this.guiForChild.get());
        s.append("}");
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[Command, name=");
        s.append(this.name.get());
        s.append(", pattern=");
        s.append(this.pattern.get());
        s.append(", description=");
        s.append(this.description.get());
        s.append(", enabled=");
        s.append(this.enabled.get());
        s.append("]");
        return s.toString();
    }
}

