/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.EntityAddException;
import com.swiftmq.mgmt.EntityAddListener;
import com.swiftmq.mgmt.EntityList;
import com.swiftmq.mgmt.EntityRemoveException;
import com.swiftmq.mgmt.EntityRemoveListener;
import com.swiftmq.mgmt.EntityWatchListener;
import com.swiftmq.mgmt.MgmtFactory;
import com.swiftmq.mgmt.Property;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.DumpableFactory;
import com.swiftmq.tools.dump.Dumpalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;

public class Entity
implements Dumpable {
    public static final String SET_COMMAND = "set";
    protected DumpableFactory factory = new MgmtFactory();
    String name = null;
    String displayName = null;
    String description = null;
    boolean dynamic = false;
    transient Object userObject = null;
    transient Object dynamicObject = null;
    String[] dynamicPropNames = null;
    CommandRegistry commandRegistry = null;
    Entity parent = null;
    Map properties = null;
    String state = null;
    byte[] imageArray = null;
    transient ImageIcon imageIcon = null;
    transient String iconFilename = null;
    Map entities = null;
    transient EntityAddListener entityAddListener;
    transient EntityRemoveListener entityRemoveListener;
    transient List watchListeners = null;
    transient boolean upgrade = false;
    volatile String[] _ctx = null;
    volatile String[] _dctx = null;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public Entity(String name, String displayName, String description, String state) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.state = state;
        this.entities = new CloneableMap();
        this.properties = new CloneableMap();
    }

    protected Entity() {
        this(null, null, null, null);
    }

    @Override
    public int getDumpId() {
        return 0;
    }

    protected boolean isSetParent() {
        return true;
    }

    protected void writeDump(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    protected String readDump(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return in.readUTF();
        }
        return null;
    }

    protected void writeDump(DataOutput out, String[] s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(s.length);
            for (int i = 0; i < s.length; ++i) {
                out.writeUTF(s[i]);
            }
        }
    }

    protected String[] readDumpStringArray(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            String[] s = new String[in.readInt()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = in.readUTF();
            }
            return s;
        }
        return null;
    }

    protected void writeDump(DataOutput out, byte[] s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(s.length);
            out.write(s);
        }
    }

    protected byte[] readDumpByteArray(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            byte[] s = new byte[in.readInt()];
            in.readFully(s);
            return s;
        }
        return null;
    }

    protected void writeDump(DataOutput out, Dumpable d) throws IOException {
        if (d == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            Dumpalizer.dump(out, d);
        }
    }

    protected Dumpable readDumpDumpable(DataInput in, DumpableFactory factory) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return Dumpalizer.construct(in, factory);
        }
        return null;
    }

    protected void writeDump(DataOutput out, Map map) throws IOException {
        if (map == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(map.size());
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Dumpalizer.dump(out, (Dumpable)iter.next().getValue());
            }
        }
    }

    protected CloneableMap readDumpDumpablePropMap(DataInput in, DumpableFactory factory) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            CloneableMap map = new CloneableMap();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Property prop = (Property)Dumpalizer.construct(in, factory);
                prop.setParent(this);
                map.put(prop.getName(), prop);
            }
            return map;
        }
        return null;
    }

    protected CloneableMap readDumpDumpableEntityMap(DataInput in, DumpableFactory factory) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            CloneableMap map = new CloneableMap();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Entity entity = (Entity)Dumpalizer.construct(in, factory);
                if (this.isSetParent()) {
                    entity.setParent(this);
                }
                map.put(entity.getName(), entity);
            }
            return map;
        }
        return null;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        this.lock.readLock().lock();
        try {
            this.writeDump(out, this.name);
            this.writeDump(out, this.displayName);
            this.writeDump(out, this.description);
            this.writeDump(out, this.state);
            out.writeBoolean(this.dynamic);
            this.writeDump(out, this.dynamicPropNames);
            this.writeDump(out, this.commandRegistry);
            this.writeDump(out, this.imageArray);
            this.writeDump(out, this.properties);
            this.writeDump(out, this.entities);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.name = this.readDump(in);
            this.displayName = this.readDump(in);
            this.description = this.readDump(in);
            this.state = this.readDump(in);
            this.dynamic = in.readBoolean();
            this.dynamicPropNames = this.readDumpStringArray(in);
            this.commandRegistry = (CommandRegistry)this.readDumpDumpable(in, this.factory);
            this.imageArray = this.readDumpByteArray(in);
            this.properties = this.readDumpDumpablePropMap(in, this.factory);
            this.entities = this.readDumpDumpableEntityMap(in, this.factory);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setImageArray(byte[] array) {
        this.lock.writeLock().lock();
        try {
            this.imageArray = array;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    String getIconFilename() {
        this.lock.readLock().lock();
        try {
            String string = this.iconFilename;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void setIconFilename(String iconFilename) {
        this.lock.writeLock().lock();
        try {
            this.iconFilename = iconFilename;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ImageIcon getIcon() {
        this.lock.readLock().lock();
        try {
            if (this.imageArray == null) {
                ImageIcon imageIcon = null;
                return imageIcon;
            }
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(this.imageArray);
            }
            ImageIcon imageIcon = this.imageIcon;
            return imageIcon;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isDynamic() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.dynamic;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDynamic(boolean b) {
        this.lock.writeLock().lock();
        try {
            this.dynamic = b;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Object getUserObject() {
        this.lock.readLock().lock();
        try {
            Object object = this.userObject;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setUserObject(Object userObject) {
        this.lock.writeLock().lock();
        try {
            this.userObject = userObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Object getDynamicObject() {
        this.lock.readLock().lock();
        try {
            Object object = this.dynamicObject;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDynamicObject(Object dynamicObject) {
        this.lock.writeLock().lock();
        try {
            this.dynamicObject = dynamicObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String[] getDynamicPropNames() {
        this.lock.readLock().lock();
        try {
            String[] stringArray = this.dynamicPropNames;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDynamicPropNames(String[] dynamicPropNames) {
        this.lock.writeLock().lock();
        try {
            this.dynamicPropNames = dynamicPropNames;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getContext() {
        this.lock.readLock().lock();
        try {
            if (this._ctx != null) {
                String[] stringArray = this._ctx;
                return stringArray;
            }
            ArrayList<String> al = new ArrayList<String>();
            for (Entity actEntity = this; actEntity != null; actEntity = actEntity.getParent()) {
                al.add(actEntity.getName());
            }
            String[] ctx = new String[al.size()];
            int j = 0;
            for (int i = al.size() - 1; i >= 0; --i) {
                ctx[j++] = (String)al.get(i);
            }
            this._ctx = ctx;
            String[] stringArray = this._ctx;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDisplayContext() {
        this.lock.readLock().lock();
        try {
            if (this._dctx != null) {
                String[] stringArray = this._dctx;
                return stringArray;
            }
            ArrayList<String> al = new ArrayList<String>();
            for (Entity actEntity = this; actEntity != null; actEntity = actEntity.getParent()) {
                al.add(actEntity.getDisplayName());
            }
            String[] ctx = new String[al.size()];
            int j = 0;
            for (int i = al.size() - 1; i >= 0; --i) {
                ctx[j++] = (String)al.get(i);
            }
            this._dctx = ctx;
            String[] stringArray = this._dctx;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCommands() {
        Map cloned = null;
        this.lock.readLock().lock();
        try {
            this.commandRegistry = new CommandRegistry("Context '" + this.name + "'", null);
            CommandExecutor setExecutor = new CommandExecutor(){

                @Override
                public String[] execute(String[] context, Entity entity, String[] cmd) {
                    if (cmd.length < 2 || cmd.length > 3) {
                        return new String[]{"Error:", "Invalid command, please try 'set <prop> [<value>]'"};
                    }
                    String[] result = null;
                    Property p = Entity.this.getProperty(cmd[1]);
                    if (p == null) {
                        result = new String[]{"Error:", "Unknown Property: " + cmd[1]};
                    } else if (p.isReadOnly()) {
                        result = new String[]{"Error:", "Property is read-only."};
                    } else {
                        try {
                            if (cmd.length == 2) {
                                p.setValue(null);
                            } else {
                                p.setValue(Property.convertToType(p.getType(), cmd[2]));
                            }
                            if (p.isRebootRequired()) {
                                result = new String[]{"Information:", "To activate this Property Change, a Reboot of this Router is required."};
                            }
                        }
                        catch (Exception e) {
                            result = new String[]{"Error:", e.getMessage()};
                        }
                    }
                    return result;
                }
            };
            Command setCommand = new Command(SET_COMMAND, "set <prop> [<value>]", "Set Property <prop> to Value <value> or null", true, setExecutor);
            this.commandRegistry.addCommand(setCommand);
            CommandExecutor describeExecutor = new CommandExecutor(){

                private String check(Object o) {
                    return o == null ? "<not set>" : o.toString();
                }

                @Override
                public String[] execute(String[] context, Entity entity, String[] cmd) {
                    if (cmd.length != 2) {
                        return new String[]{"Error:", "Invalid command, please try 'describe <prop>'"};
                    }
                    String[] result = null;
                    Property p = Entity.this.getProperty(cmd[1]);
                    result = p == null ? new String[]{"Error:", "Unknown Property: " + cmd[1]} : new String[]{"Result:", "Property Name  : " + p.getName(), "Display Name   : " + this.check(p.getDisplayName()), "Description    : " + this.check(p.getDescription()), "Type           : " + String.valueOf(p.getType()), "Min. Value     : " + this.check(p.getMinValue()), "Max. Value     : " + this.check(p.getMaxValue()), "Default Value  : " + this.check(p.getDefaultValue()), "Poss. Values   : " + this.check(p.getPossibleValues()), "Actual Value   : " + this.check(p.getValue()), "Mandatory     : " + p.isMandatory(), "Read Only      : " + p.isReadOnly(), "Reboot Required: " + p.isRebootRequired()};
                    return result;
                }
            };
            Command describeCommand = new Command("describe", "describe <prop>", "Show full Description of Property <prop>", true, describeExecutor);
            this.commandRegistry.addCommand(describeCommand);
            cloned = (Map)((TreeMap)this.entities).clone();
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (Map.Entry o : cloned.entrySet()) {
            Entity entity = (Entity)o.getValue();
            entity.createCommands();
        }
    }

    public CommandRegistry getCommandRegistry() {
        this.lock.readLock().lock();
        try {
            CommandRegistry commandRegistry = this.commandRegistry;
            return commandRegistry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getName() {
        this.lock.readLock().lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setName(String name) {
        this.lock.writeLock().lock();
        try {
            this.name = name;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getDisplayName() {
        this.lock.readLock().lock();
        try {
            String string = this.displayName;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getDescription() {
        this.lock.readLock().lock();
        try {
            String string = this.description;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addCommand(String name, Command command) {
        this.lock.writeLock().lock();
        try {
            command.setParent(this);
            this.commandRegistry.addCommand(command);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeCommand(String name) {
        this.lock.writeLock().lock();
        try {
            Command cmd = this.commandRegistry.findCommand(new String[]{name});
            if (cmd != null) {
                this.commandRegistry.removeCommand(cmd);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getState() {
        this.lock.readLock().lock();
        try {
            String string = this.state;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setState(String state) {
        this.lock.writeLock().lock();
        try {
            this.state = state;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addProperty(String name, Property property) {
        this.lock.writeLock().lock();
        try {
            property.setParent(this);
            this.properties.put(name, property);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeProperty(String name) {
        this.lock.writeLock().lock();
        try {
            this.properties.remove(name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Property getProperty(String name) {
        this.lock.readLock().lock();
        try {
            Property property = (Property)this.properties.get(name);
            return property;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map getProperties() {
        this.lock.readLock().lock();
        try {
            CloneableMap cloneableMap = ((CloneableMap)this.properties).createCopy();
            return cloneableMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntity(Entity entity) throws EntityAddException {
        EntityAddListener listener = null;
        this.lock.readLock().lock();
        try {
            listener = this.entityAddListener;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (listener != null) {
            listener.onEntityAdd(this, entity);
        }
        entity.setParent(this);
        this.lock.writeLock().lock();
        try {
            this.entities.put(entity.getName(), entity);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyEntityWatchListeners(true, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(Entity entity) throws EntityRemoveException {
        EntityRemoveListener listener;
        if (entity == null) {
            return;
        }
        this.lock.readLock().lock();
        try {
            listener = this.entityRemoveListener;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (listener != null) {
            listener.onEntityRemove(this, entity);
        }
        this.lock.writeLock().lock();
        try {
            this.entities.remove(entity.getName());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        entity.setParent(null);
        this.notifyEntityWatchListeners(false, entity);
    }

    public void removeEntities() {
        this.lock.writeLock().lock();
        try {
            this.entities.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicEntity(Object dynamicObject) {
        Entity entity = null;
        this.lock.writeLock().lock();
        try {
            Iterator iter = this.entities.entrySet().iterator();
            while (iter.hasNext()) {
                entity = (Entity)iter.next().getValue();
                if (entity.getDynamicObject() != dynamicObject) continue;
                entity.setDynamicObject(null);
                entity.setParent(null);
                iter.remove();
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (entity != null) {
            this.notifyEntityWatchListeners(false, entity);
        }
    }

    public Entity getEntity(String name) {
        this.lock.readLock().lock();
        try {
            Entity entity = (Entity)this.entities.get(name);
            return entity;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEntityNames() {
        this.lock.readLock().lock();
        try {
            if (this.entities.size() == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] rArr = new String[this.entities.size()];
            int i = 0;
            Iterator iter = this.entities.keySet().iterator();
            while (iter.hasNext()) {
                rArr[i++] = (String)iter.next();
            }
            String[] stringArray = rArr;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map getEntities() {
        this.lock.readLock().lock();
        try {
            CloneableMap cloneableMap = ((CloneableMap)this.entities).createCopy();
            return cloneableMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Entity getParent() {
        this.lock.readLock().lock();
        try {
            Entity entity = this.parent;
            return entity;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void setParent(Entity parent) {
        this.lock.writeLock().lock();
        try {
            this.parent = parent;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public EntityAddListener getEntityAddListener() {
        this.lock.readLock().lock();
        try {
            EntityAddListener entityAddListener = this.entityAddListener;
            return entityAddListener;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setEntityAddListener(EntityAddListener entityAddListener) {
        this.lock.writeLock().lock();
        try {
            this.entityAddListener = entityAddListener;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public EntityRemoveListener getEntityRemoveListener() {
        this.lock.readLock().lock();
        try {
            EntityRemoveListener entityRemoveListener = this.entityRemoveListener;
            return entityRemoveListener;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setEntityRemoveListener(EntityRemoveListener entityRemoveListener) {
        this.lock.writeLock().lock();
        try {
            this.entityRemoveListener = entityRemoveListener;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addEntityWatchListener(EntityWatchListener l) {
        this.lock.writeLock().lock();
        try {
            if (this.watchListeners == null) {
                this.watchListeners = new ArrayList();
            }
            this.watchListeners.add(l);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeEntityWatchListener(EntityWatchListener l) {
        this.lock.writeLock().lock();
        try {
            if (this.watchListeners != null) {
                this.watchListeners.remove(l);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List copyOf(List in) {
        this.lock.readLock().lock();
        try {
            ArrayList out = new ArrayList();
            if (in != null) {
                out.addAll(in);
            }
            ArrayList arrayList = out;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void notifyEntityWatchListeners(boolean entityAdded, Entity entity) {
        List copy = this.copyOf(this.watchListeners);
        IntStream.range(0, copy.size()).mapToObj(i -> (EntityWatchListener)this.watchListeners.get(i)).forEach(l -> {
            if (entityAdded) {
                l.entityAdded(this, entity);
            } else {
                l.entityRemoved(this, entity);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity createCopy() {
        this.lock.readLock().lock();
        try {
            Entity entity = new Entity(this.name, this.displayName, this.description, this.state);
            entity.dynamic = this.dynamic;
            entity.dynamicPropNames = this.dynamicPropNames;
            entity.commandRegistry = this.commandRegistry;
            entity.properties = new CloneableMap();
            for (Map.Entry o : this.properties.entrySet()) {
                Property p = (Property)o.getValue();
                Property copy = p.createCopy();
                copy.setParent(entity);
                entity.properties.put(copy.getName(), copy);
            }
            Entity entity2 = entity;
            return entity2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isUpgrade() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.upgrade;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setUpgrade(boolean upgrade) {
        this.lock.writeLock().lock();
        try {
            this.upgrade = upgrade;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected String quote(String s) {
        return "\"" + s + "\"";
    }

    protected boolean commandIncluded(Command command, String[] exclude) {
        return IntStream.range(0, exclude.length).noneMatch(i -> exclude[i].equals(command.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJson() {
        this.lock.readLock().lock();
        try {
            boolean first;
            StringBuffer s = new StringBuffer();
            s.append("{");
            s.append(this.quote("nodetype")).append(": ");
            s.append(this.quote("entity")).append(", ");
            s.append(this.quote("name")).append(": ");
            s.append(this.quote(this.name)).append(", ");
            s.append(this.quote("displayName")).append(": ");
            s.append(this.quote(this.displayName)).append(", ");
            s.append(this.quote("description")).append(": ");
            s.append(this.quote(this.description)).append(", ");
            s.append(this.quote("hasChilds")).append(": ");
            s.append(this.entities != null && this.entities.size() > 0);
            if (this.properties != null) {
                s.append(", ");
                s.append(this.quote("properties")).append(": ");
                s.append("[");
                first = true;
                for (Map.Entry o : this.properties.entrySet()) {
                    if (!first) {
                        s.append(", ");
                    }
                    first = false;
                    Property p = (Property)o.getValue();
                    s.append(p.toJson());
                }
                s.append("]");
            }
            if (this.entities != null) {
                s.append(", ");
                s.append(this.quote("entities")).append(": ");
                s.append("[");
                first = true;
                for (Map.Entry o : this.entities.entrySet()) {
                    if (!first) {
                        s.append(", ");
                    }
                    first = false;
                    Entity e = (Entity)o.getValue();
                    s.append("{");
                    s.append(this.quote("nodetype")).append(": ");
                    if (e instanceof EntityList) {
                        s.append(this.quote("entitylist")).append(", ");
                    } else {
                        s.append(this.quote("entity")).append(", ");
                    }
                    s.append(this.quote("name")).append(": ");
                    s.append(this.quote(e.getName())).append(", ");
                    s.append(this.quote("displayName")).append(": ");
                    s.append(this.quote(e.getDisplayName())).append(", ");
                    s.append(this.quote("description")).append(": ");
                    s.append(this.quote(e.getDescription())).append(", ");
                    s.append(this.quote("hasChilds")).append(": ");
                    if (e instanceof EntityList) {
                        s.append(true);
                    } else {
                        s.append(e.getEntities() != null && e.getEntities().size() > 0);
                    }
                    s.append("}");
                }
                s.append("]");
            }
            if (this.commandRegistry != null && this.commandRegistry.getCommands() != null) {
                s.append(", ");
                s.append(this.quote("commands")).append(": ");
                s.append("[");
                List cmds = this.commandRegistry.getCommands();
                boolean first2 = true;
                for (int i = 0; i < cmds.size(); ++i) {
                    Command command = (Command)cmds.get(i);
                    if (!this.commandIncluded(command, new String[]{"help", SET_COMMAND, "describe"})) continue;
                    if (!first2) {
                        s.append(", ");
                    }
                    first2 = false;
                    s.append(((Command)cmds.get(i)).toJson());
                }
                s.append("]");
            }
            s.append("}");
            String string = s.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            StringBuffer s = new StringBuffer();
            s.append("\n[Entity, name=");
            s.append(this.name);
            s.append(", displayName=");
            s.append(this.displayName);
            s.append(", description=");
            s.append(this.description);
            s.append(", state=");
            s.append(this.state);
            s.append(", properties=");
            s.append(this.properties);
            s.append(", entities=");
            s.append(this.entities);
            s.append("]");
            String string = s.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected class CloneableMap
    extends TreeMap {
        protected CloneableMap() {
        }

        public CloneableMap createCopy() {
            return (CloneableMap)this.clone();
        }
    }
}

