/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.InvalidTypeException;
import com.swiftmq.mgmt.InvalidValueException;
import com.swiftmq.mgmt.PropertyChangeException;
import com.swiftmq.mgmt.PropertyChangeListener;
import com.swiftmq.mgmt.PropertyWatchListener;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.IntStream;

public class Property
implements Dumpable {
    String name = null;
    Entity parent = null;
    String displayName = null;
    String description = null;
    Class type = null;
    boolean readOnly = false;
    boolean mandatory = false;
    boolean rebootRequired = false;
    boolean storable = true;
    Object value = null;
    Comparable minValue = null;
    Comparable maxValue = null;
    Object defaultValue = null;
    List possibleValues = null;
    List possibleValueDescriptions = null;
    transient PropertyChangeListener propertyChangeListener;
    transient List watchListeners = null;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public Property(String name) {
        this.name = name;
    }

    Property() {
    }

    public static Object convertToType(Class type, String v) throws InvalidTypeException {
        Object r = null;
        try {
            if (type == String.class) {
                r = v;
            } else if (type == Boolean.class) {
                r = Boolean.valueOf(v);
            } else if (type == Double.class) {
                r = Double.valueOf(v);
            } else if (type == Integer.class) {
                r = Integer.valueOf(v);
            } else if (type == Long.class) {
                r = Long.valueOf(v);
            } else if (type == Float.class) {
                r = Float.valueOf(v);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidTypeException("invalid type for value; does not match " + String.valueOf(type));
        }
        return r;
    }

    @Override
    public int getDumpId() {
        return 2;
    }

    private void writeDump(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    private String readDump(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return in.readUTF();
        }
        return null;
    }

    private void writeList(DataOutput out, List vl, Class type) throws IOException {
        if (vl == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(vl.size());
            for (int i = 0; i < vl.size(); ++i) {
                this.writeValue(out, vl.get(i), type);
            }
        }
    }

    private List readDump(DataInput in, Class type) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            int size = in.readInt();
            ArrayList<Object> vl = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                vl.add(this.readValue(in, type));
            }
            return vl;
        }
        return null;
    }

    private void writeList(DataOutput out, List vl) throws IOException {
        if (vl == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(vl.size());
            for (int i = 0; i < vl.size(); ++i) {
                out.writeUTF((String)vl.get(i));
            }
        }
    }

    private List readList(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            int size = in.readInt();
            ArrayList<String> vl = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                vl.add(in.readUTF());
            }
            return vl;
        }
        return null;
    }

    private void writeValue(DataOutput out, Object v, Class type) throws IOException {
        if (v == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (type == String.class) {
                out.writeUTF((String)v);
            } else if (type == Boolean.class) {
                out.writeBoolean(Boolean.parseBoolean(v.toString()));
            } else if (type == Double.class) {
                out.writeDouble(Double.parseDouble(v.toString()));
            } else if (type == Integer.class) {
                out.writeInt(Integer.parseInt(v.toString()));
            } else if (type == Long.class) {
                out.writeLong(Long.parseLong(v.toString()));
            } else if (type == Float.class) {
                out.writeFloat(Float.parseFloat(v.toString()));
            }
        }
    }

    private Object readValue(DataInput in, Class type) throws IOException {
        Object v = null;
        byte set = in.readByte();
        if (set == 1) {
            if (type == String.class) {
                v = in.readUTF();
            } else if (type == Boolean.class) {
                v = in.readBoolean();
            } else if (type == Double.class) {
                v = in.readDouble();
            } else if (type == Integer.class) {
                v = in.readInt();
            } else if (type == Long.class) {
                v = in.readLong();
            } else if (type == Float.class) {
                v = Float.valueOf(in.readFloat());
            }
        }
        return v;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        this.lock.readLock().lock();
        try {
            this.writeDump(out, this.name);
            this.writeDump(out, this.displayName);
            this.writeDump(out, this.description);
            this.writeDump(out, this.type.getName());
            out.writeBoolean(this.readOnly);
            out.writeBoolean(this.mandatory);
            out.writeBoolean(this.rebootRequired);
            out.writeBoolean(this.storable);
            this.writeValue(out, this.value, this.type);
            this.writeValue(out, this.minValue, this.type);
            this.writeValue(out, this.maxValue, this.type);
            this.writeValue(out, this.defaultValue, this.type);
            this.writeList(out, this.possibleValues, this.type);
            this.writeList(out, this.possibleValueDescriptions);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.name = this.readDump(in);
            this.displayName = this.readDump(in);
            this.description = this.readDump(in);
            try {
                this.type = Class.forName(this.readDump(in));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.readOnly = in.readBoolean();
            this.mandatory = in.readBoolean();
            this.rebootRequired = in.readBoolean();
            this.storable = in.readBoolean();
            this.value = this.readValue(in, this.type);
            this.minValue = (Comparable)this.readValue(in, this.type);
            this.maxValue = (Comparable)this.readValue(in, this.type);
            this.defaultValue = this.readValue(in, this.type);
            this.possibleValues = this.readDump(in, this.type);
            this.possibleValueDescriptions = this.readList(in);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getName() {
        this.lock.readLock().lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getDisplayName() {
        this.lock.readLock().lock();
        try {
            String string = this.displayName;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDisplayName(String displayName) {
        this.lock.writeLock().lock();
        try {
            this.displayName = displayName;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getDescription() {
        this.lock.readLock().lock();
        try {
            String string = this.description;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDescription(String description) {
        this.lock.writeLock().lock();
        try {
            this.description = description;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean isInPossibleList(Object v) {
        if (this.possibleValues == null) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return IntStream.range(0, this.possibleValues.size()).anyMatch(i -> ((Comparable)this.possibleValues.get(i)).compareTo(v) == 0);
    }

    public Object getValue() {
        this.lock.readLock().lock();
        try {
            if (this.value != null) {
                Object object = this.value;
                return object;
            }
            Object object = this.defaultValue;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setValue(Object value) throws InvalidValueException, InvalidTypeException, PropertyChangeException {
        PropertyChangeListener listener = null;
        this.lock.writeLock().lock();
        try {
            if (value != null) {
                if (this.type == null) {
                    throw new InvalidTypeException("no type set");
                }
                if (this.type != value.getClass()) {
                    throw new InvalidTypeException("invalid type for value; does not match " + String.valueOf(this.type));
                }
                if (this.minValue != null && this.minValue.compareTo(value) > 0) {
                    throw new InvalidValueException("invalid value, must be >= " + String.valueOf(this.minValue));
                }
                if (this.maxValue != null && this.maxValue.compareTo(value) < 0) {
                    throw new InvalidValueException("invalid value, must be <= " + String.valueOf(this.maxValue));
                }
                if (!this.isInPossibleList(value)) {
                    throw new InvalidValueException("invalid value, must be in " + String.valueOf(this.possibleValues));
                }
            } else {
                if (this.mandatory && this.defaultValue == null) {
                    throw new InvalidValueException("Property is mandatory, value can't be null");
                }
                if (this.type != String.class) {
                    throw new InvalidValueException("Null values are only possible for String types");
                }
            }
            this.value = value;
            listener = this.propertyChangeListener;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (listener != null) {
            listener.propertyChanged(this, this.value, value);
        }
        this.notifyPropertyWatchListeners();
    }

    public Class getType() {
        this.lock.readLock().lock();
        try {
            Class clazz = this.type;
            return clazz;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setType(Class type) throws InvalidTypeException {
        block4: {
            this.lock.writeLock().lock();
            try {
                if (type == null || type == Boolean.class || type == Double.class || type == Integer.class || type == Long.class || type == String.class || type == Float.class) {
                    this.type = type;
                    break block4;
                }
                throw new InvalidTypeException("invalid type; must be of Boolean, Double, Integer, Long, Float, String");
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public boolean isReadOnly() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.readOnly;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.lock.writeLock().lock();
        try {
            this.readOnly = readOnly;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isStorable() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.storable;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setStorable(boolean storable) {
        this.lock.writeLock().lock();
        try {
            this.storable = storable;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isRebootRequired() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.rebootRequired;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setRebootRequired(boolean rebootRequired) {
        this.lock.writeLock().lock();
        try {
            this.rebootRequired = rebootRequired;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isMandatory() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mandatory;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMandatory(boolean mandatory) {
        this.lock.writeLock().lock();
        try {
            this.mandatory = mandatory;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Comparable getMinValue() {
        this.lock.readLock().lock();
        try {
            Comparable comparable = this.minValue;
            return comparable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMinValue(Comparable minValue) throws InvalidTypeException {
        this.lock.writeLock().lock();
        try {
            if (this.type == null) {
                throw new InvalidTypeException("type not set");
            }
            this.minValue = minValue;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Comparable getMaxValue() {
        this.lock.readLock().lock();
        try {
            Comparable comparable = this.maxValue;
            return comparable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMaxValue(Comparable maxValue) throws InvalidTypeException {
        this.lock.writeLock().lock();
        try {
            if (this.type == null) {
                throw new InvalidTypeException("type not set");
            }
            this.maxValue = maxValue;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List getPossibleValues() {
        this.lock.readLock().lock();
        try {
            List list = this.possibleValues;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPossibleValues(List possibleValues) throws InvalidTypeException {
        this.lock.writeLock().lock();
        try {
            if (this.type == null) {
                throw new InvalidTypeException("type not set");
            }
            if (possibleValues != null) {
                for (Object value : possibleValues) {
                    if (value == null || this.type == value.getClass()) continue;
                    throw new InvalidTypeException("invalid type for value '" + String.valueOf(value) + "'; does not match " + String.valueOf(this.type));
                }
            }
            this.possibleValues = possibleValues;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List getPossibleValueDescriptions() {
        this.lock.readLock().lock();
        try {
            List list = this.possibleValueDescriptions;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setPossibleValueDescriptions(List possibleValueDescriptions) {
        this.lock.writeLock().lock();
        try {
            this.possibleValueDescriptions = possibleValueDescriptions;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Object getDefaultValue() {
        this.lock.readLock().lock();
        try {
            Object object = this.defaultValue;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDefaultValue(Object defaultValue) {
        this.lock.writeLock().lock();
        try {
            this.defaultValue = defaultValue;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setDefaultProp(Property defaultProp) {
        this.lock.writeLock().lock();
        try {
            if (defaultProp != null) {
                this.defaultValue = defaultProp.getValue();
                defaultProp.addPropertyWatchListener(new PropertyWatchListener(){

                    @Override
                    public void propertyValueChanged(Property p) {
                        Property.this.defaultValue = p.getValue();
                    }
                });
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public PropertyChangeListener getPropertyChangeListener() {
        this.lock.readLock().lock();
        try {
            PropertyChangeListener propertyChangeListener = this.propertyChangeListener;
            return propertyChangeListener;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.lock.writeLock().lock();
        try {
            this.propertyChangeListener = propertyChangeListener;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addPropertyWatchListener(PropertyWatchListener l) {
        this.lock.writeLock().lock();
        try {
            if (this.watchListeners == null) {
                this.watchListeners = new ArrayList();
            }
            this.watchListeners.add(l);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removePropertyWatchListener(PropertyWatchListener l) {
        this.lock.writeLock().lock();
        try {
            if (this.watchListeners != null) {
                this.watchListeners.remove(l);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List copyOf(List in) {
        this.lock.readLock().lock();
        try {
            ArrayList out = new ArrayList();
            if (in != null) {
                out.addAll(in);
            }
            ArrayList arrayList = out;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void notifyPropertyWatchListeners() {
        List copy = this.copyOf(this.watchListeners);
        for (Object watchListener : copy) {
            PropertyWatchListener l = (PropertyWatchListener)watchListener;
            l.propertyValueChanged(this);
        }
    }

    public Entity getParent() {
        this.lock.readLock().lock();
        try {
            Entity entity = this.parent;
            return entity;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void setParent(Entity parent) {
        this.lock.writeLock().lock();
        try {
            this.parent = parent;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Property createCopy() {
        this.lock.readLock().lock();
        try {
            Property prop = new Property(this.name);
            prop.displayName = this.displayName;
            prop.description = this.description;
            prop.type = this.type;
            prop.readOnly = this.readOnly;
            prop.mandatory = this.mandatory;
            prop.rebootRequired = this.rebootRequired;
            prop.storable = this.storable;
            prop.value = this.value;
            prop.minValue = this.minValue;
            prop.maxValue = this.maxValue;
            prop.defaultValue = this.defaultValue;
            prop.possibleValues = this.possibleValues;
            prop.possibleValueDescriptions = this.possibleValueDescriptions;
            Property property = prop;
            return property;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String escapeJsonControls(String s) {
        return SwiftUtilities.replace(s, "\\", "\\\\").replace("\"", "\\\"");
    }

    private String quote(String s) {
        return "\"" + this.escapeJsonControls(s) + "\"";
    }

    public String toJson() {
        this.lock.readLock().lock();
        try {
            StringBuffer s = new StringBuffer();
            s.append("{");
            s.append(this.quote("name")).append(": ");
            s.append(this.quote(this.name)).append(", ");
            s.append(this.quote("displayName")).append(": ");
            s.append(this.quote(this.displayName)).append(", ");
            s.append(this.quote("description")).append(": ");
            s.append(this.quote(this.description)).append(", ");
            s.append(this.quote("type")).append(": ");
            s.append(this.quote(this.type.getSimpleName())).append(", ");
            s.append(this.quote("readOnly")).append(": ");
            s.append(this.readOnly).append(", ");
            s.append(this.quote("mandatory")).append(": ");
            s.append(this.mandatory).append(", ");
            s.append(this.quote("rebootRequired")).append(": ");
            s.append(this.rebootRequired);
            if (this.value != null) {
                s.append(", ");
                s.append(this.quote("value")).append(": ");
                if (this.value instanceof String) {
                    s.append(this.quote((String)this.value));
                } else {
                    s.append(this.value);
                }
            }
            if (this.minValue != null) {
                s.append(", ");
                s.append(this.quote("minValue")).append(": ");
                s.append(this.minValue);
            }
            if (this.maxValue != null) {
                s.append(", ");
                s.append(this.quote("maxValue")).append(": ");
                s.append(this.maxValue);
            }
            if (this.defaultValue != null) {
                s.append(", ");
                s.append(this.quote("defaultValue")).append(": ");
                if (this.type == String.class) {
                    s.append(this.quote((String)this.defaultValue));
                } else {
                    s.append(this.defaultValue);
                }
            }
            if (this.possibleValues != null) {
                s.append(", ");
                s.append(this.quote("possibleValues")).append(": ");
                s.append("[");
                for (int i = 0; i < this.possibleValues.size(); ++i) {
                    if (i > 0) {
                        s.append(", ");
                    }
                    s.append(this.quote(this.possibleValues.get(i).toString()));
                }
                s.append("]");
            }
            s.append("}");
            String string = s.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            StringBuffer s = new StringBuffer();
            s.append("[Property, name=");
            s.append(this.name);
            s.append(", displayName=");
            s.append(this.displayName);
            s.append(", description=");
            s.append(this.description);
            s.append(", type=");
            s.append(this.type);
            s.append(", value=");
            s.append(this.value);
            s.append(", readOnly=");
            s.append(this.readOnly);
            s.append(", storable=");
            s.append(this.storable);
            s.append(", mandatory=");
            s.append(this.mandatory);
            s.append(", rebootRequired=");
            s.append(this.rebootRequired);
            s.append(", minValue=");
            s.append(this.minValue);
            s.append(", maxValue=");
            s.append(this.maxValue);
            s.append(", possibleValues=");
            s.append(this.possibleValues);
            s.append(", possibleValueDescriptions=");
            s.append(this.possibleValueDescriptions);
            s.append(", defaultValue=");
            s.append(this.defaultValue);
            s.append("]");
            String string = s.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

