/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Authenticator;
import com.swiftmq.mgmt.AuthenticatorHolder;
import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.Configuration;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.EntityAddException;
import com.swiftmq.mgmt.EntityAddListener;
import com.swiftmq.mgmt.EntityList;
import com.swiftmq.mgmt.MetaData;
import com.swiftmq.mgmt.Property;
import com.swiftmq.swiftlet.SwiftletManager;
import com.swiftmq.util.SwiftUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RouterConfigInstance
extends EntityList {
    Entity currentEntity = null;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected RouterConfigInstance() {
        super(null, null, null, null, null);
    }

    @Override
    protected boolean isSetParent() {
        return false;
    }

    @Override
    public int getDumpId() {
        return 4;
    }

    public void setCommandRegistry(CommandRegistry commandRegistry) {
        this.lock.writeLock().lock();
        try {
            this.commandRegistry = commandRegistry;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntity(Entity entity) throws EntityAddException {
        Entity config = entity;
        this.lock.writeLock().lock();
        try {
            this.entities.put(config.getName(), config);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        EntityAddListener listener = null;
        this.lock.readLock().lock();
        try {
            listener = this.entityAddListener;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (listener != null) {
            config = listener.onConfigurationAdd(this, entity);
        }
        this.notifyEntityWatchListeners(true, config);
    }

    public Map getConfigurations() {
        this.lock.readLock().lock();
        try {
            Map map = this.entities;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clearConfigurations() {
        this.lock.writeLock().lock();
        try {
            this.entities.clear();
            this.properties.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContext(Object currentContext, String[] context, int stacklevel) {
        this.lock.readLock().lock();
        try {
            if (context == null || context.length == 0) {
                Object var4_4 = null;
                return var4_4;
            }
            if (currentContext == null) {
                Entity entity = (Entity)SwiftUtilities.getFirstStartsWith(this.entities, context[stacklevel]);
                if (entity == null) {
                    Object var5_7 = null;
                    return var5_7;
                }
                if (stacklevel == context.length - 1) {
                    Entity entity2 = entity;
                    return entity2;
                }
                Object object = this.getContext(entity, context, stacklevel + 1);
                return object;
            }
            Entity entity = (Entity)SwiftUtilities.getFirstStartsWith(((Entity)currentContext).getEntities(), context[stacklevel]);
            if (entity == null) {
                Object var5_10 = null;
                return var5_10;
            }
            if (stacklevel == context.length - 1) {
                Entity entity3 = entity;
                return entity3;
            }
            Object object = this.getContext(entity, context, stacklevel + 1);
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String stateToString(int state) {
        if (state == 0) {
            return "ACTIVE";
        }
        if (state == 1) {
            return "INACTIVE";
        }
        return "UNKNOWN";
    }

    private String[] dirSwiftlets() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("Result:");
        al.add("Swiftlet Name       State    Description");
        al.add("-------------------------------------------------------------");
        for (String name : this.entities.keySet()) {
            Configuration c = (Configuration)this.entities.get(name);
            MetaData meta = c.getMetaData();
            StringBuffer b = new StringBuffer();
            b.append(SwiftUtilities.fillToLength(name, 20));
            try {
                b.append(SwiftUtilities.fillToLength(this.stateToString(SwiftletManager.getInstance().getSwiftletState(name)), 9));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (meta != null) {
                b.append(meta.getDescription());
            } else {
                b.append("<not specified>");
            }
            al.add(b.toString());
        }
        return al.toArray(new String[al.size()]);
    }

    private String[] dirEntityList(EntityList list) {
        ArrayList<Object> al = new ArrayList<Object>();
        al.add("Result:");
        al.add("Entity List: " + list.getDisplayName());
        al.add("Description: " + list.getDescription());
        al.add("");
        Map m = list.getEntities();
        if (m.size() == 0) {
            al.add("List contains no Entities.");
        } else {
            al.add("Number of Entities in this List: " + m.size());
            al.add("--------------------------------");
            for (String name : m.keySet()) {
                al.add(name);
            }
        }
        return al.toArray(new String[al.size()]);
    }

    private String[] dirEntityList(EntityList list, Authenticator authenticator) {
        Map m = list.getEntities();
        ArrayList<String> stripped = new ArrayList<String>();
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            Entity entity = (Entity)iter.next().getValue();
            if (!authenticator.isContextGranted(entity)) continue;
            stripped.add(entity.getName());
        }
        ArrayList<Object> al = new ArrayList<Object>();
        al.add("Result:");
        al.add("Entity List: " + list.getDisplayName());
        al.add("Description: " + list.getDescription());
        al.add("");
        if (stripped.size() == 0) {
            al.add("List contains no Entities.");
        } else {
            al.add("Number of Entities in this List: " + m.size());
            al.add("--------------------------------");
            al.addAll(stripped);
        }
        return al.toArray(new String[al.size()]);
    }

    private String[] dirEntity(Entity entity) {
        ArrayList<Object> al = new ArrayList<Object>();
        al.add("Result:");
        al.add("Entity:      " + entity.getDisplayName());
        al.add("Description: " + entity.getDescription());
        al.add("");
        Map m = entity.getProperties();
        if (m.size() == 0) {
            al.add("Entity contains no Properties.");
        } else {
            al.add("Properties for this Entity:");
            al.add("");
            al.add("Name                                    Current Value");
            al.add("--------------------------------------------------------------");
            for (Object name : m.keySet()) {
                Property p = entity.getProperty((String)name);
                if (p.isReadOnly()) {
                    name = (String)name + " (R/O)";
                }
                StringBuffer b = new StringBuffer();
                b.append(SwiftUtilities.fillToLength((String)name, 40));
                Object v = p.getValue();
                if (v == null) {
                    b.append("<not set>");
                } else {
                    b.append(v.toString());
                }
                al.add(b.toString());
            }
        }
        al.add("");
        m = entity.getEntities();
        if (m.size() == 0) {
            al.add("Entity contains no Sub-Entities.");
        } else {
            al.add("Sub-Entities of this Entity:");
            al.add("----------------------------");
            for (Object name : m.keySet()) {
                al.add(name);
            }
        }
        return al.toArray(new String[al.size()]);
    }

    private String[] dirEntity(Entity entity, Authenticator authenticator) {
        ArrayList<Object> al = new ArrayList<Object>();
        al.add("Result:");
        al.add("Entity:      " + entity.getDisplayName());
        al.add("Description: " + entity.getDescription());
        al.add("");
        Map m = entity.getProperties();
        if (m.size() == 0) {
            al.add("Entity contains no Properties.");
        } else {
            al.add("Properties for this Entity:");
            al.add("");
            al.add("Name                                    Current Value");
            al.add("--------------------------------------------------------------");
            for (Object name : m.keySet()) {
                if (!authenticator.isPropertyGranted(entity, (String)name)) continue;
                Property p = entity.getProperty((String)name);
                if (p.isReadOnly() || authenticator.isPropertyReadOnly(entity, (String)name)) {
                    name = (String)name + " (R/O)";
                }
                StringBuffer b = new StringBuffer();
                b.append(SwiftUtilities.fillToLength((String)name, 40));
                Object v = p.getValue();
                if (v == null) {
                    b.append("<not set>");
                } else {
                    b.append(v.toString());
                }
                al.add(b.toString());
            }
        }
        al.add("");
        m = entity.getEntities();
        if (m.size() == 0) {
            al.add("Entity contains no Sub-Entities.");
        } else {
            ArrayList<String> stripped = new ArrayList<String>();
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                if (!authenticator.isContextGranted(e)) continue;
                stripped.add(e.getName());
            }
            al.add("Sub-Entities of this Entity:");
            al.add("----------------------------");
            al.addAll(stripped);
        }
        return al.toArray(new String[al.size()]);
    }

    private String[] dirContext(Object context, String[] cmd) {
        if (context == null || cmd.length == 2 && cmd[1].equals("/")) {
            return this.dirEntity(this);
        }
        if (context instanceof EntityList) {
            return this.dirEntityList((EntityList)context);
        }
        return this.dirEntity((Entity)context);
    }

    private String[] dirContext(String[] ctx, Object context, String[] cmd, Authenticator authenticator) {
        if (context == null || cmd.length == 2 && cmd[1].equals("/")) {
            return this.dirEntity(this, authenticator);
        }
        if (context instanceof EntityList) {
            return this.dirEntityList((EntityList)context, authenticator);
        }
        return this.dirEntity((Entity)context, authenticator);
    }

    private String[] getContextProp(Entity context, String[] cmd) {
        String[] rc = null;
        Property prop = context.getProperty(cmd[1]);
        if (prop != null) {
            String s = null;
            if (prop.getValue() != null) {
                s = prop.getValue().toString();
                rc = new String[]{prop.getName(), s.toString()};
            } else {
                rc = new String[]{prop.getName()};
            }
        }
        return rc;
    }

    private String[] getContextEntities(Entity context) {
        return context.getEntityNames();
    }

    public String[] executeInternalCommand(String[] context, String[] cmd) {
        Object result = null;
        if (cmd[0].equals("getcontextprop")) {
            Entity ctx = (Entity)this.getContext(null, context, 0);
            result = ctx == null ? null : this.getContextProp(ctx, cmd);
        } else if (cmd[0].equals("getcontextent")) {
            Entity ctx = (Entity)this.getContext(null, context, 0);
            result = ctx == null ? null : this.getContextEntities(ctx);
        } else if (cmd[0].equals("lc")) {
            result = this.dirContext(this.getContext(null, context, 0), cmd);
        } else if (cmd[0].equals("cc")) {
            String[] ctx;
            Object c = this.getContext(null, context, 0);
            if (cmd.length == 2 && (c = this.getContext(c, ctx = SwiftUtilities.tokenize(cmd[1], "/"), 0)) == null) {
                result = new String[]{"Error:", "Unknown context"};
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] executeInternalCommand(String[] context, String[] cmd, Authenticator authenticator) {
        AuthenticatorHolder.threadLocal.set(authenticator);
        try {
            Entity ctx;
            String[] result = null;
            if (cmd[0].equals("getcontextprop")) {
                ctx = (Entity)this.getContext(null, context, 0);
                if (ctx == null) {
                    result = null;
                } else {
                    if (!authenticator.isContextGranted(ctx)) {
                        String[] stringArray = new String[]{"Error:", "Access to this context is not granted"};
                        return stringArray;
                    }
                    result = this.getContextProp(ctx, cmd);
                }
            } else if (cmd[0].equals("getcontextent")) {
                ctx = (Entity)this.getContext(null, context, 0);
                if (ctx == null) {
                    result = null;
                } else {
                    if (!authenticator.isContextGranted(ctx)) {
                        String[] stringArray = new String[]{"Error:", "Access to this context is not granted"};
                        return stringArray;
                    }
                    result = this.getContextEntities(ctx);
                }
            } else if (cmd[0].equals("lc")) {
                result = this.dirContext(context, this.getContext(null, context, 0), cmd, authenticator);
            } else if (cmd[0].equals("cc")) {
                Object c = this.getContext(null, context, 0);
                if (cmd.length == 2) {
                    String[] ctx2 = SwiftUtilities.tokenize(cmd[1], "/");
                    if ((c = this.getContext(c, ctx2, 0)) == null) {
                        result = new String[]{"Error:", "Unknown context"};
                    } else if (!authenticator.isContextGranted((Entity)c)) {
                        String[] stringArray = new String[]{"Error:", "Access to this context is not granted"};
                        return stringArray;
                    }
                }
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            AuthenticatorHolder.threadLocal.set(null);
        }
    }

    public String[] executeCommand(String[] context, String[] cmd) {
        Object c = this.getContext(null, context, 0);
        if (c != null) {
            if (c instanceof Entity) {
                this.currentEntity = (Entity)c;
                this.commandRegistry.setDefaultCommand(new CommandExecutor(){

                    @Override
                    public String[] execute(String[] context, Entity entity, String[] cmd) {
                        return RouterConfigInstance.this.currentEntity.getCommandRegistry().executeCommand(context, cmd);
                    }
                });
            } else {
                this.commandRegistry.setDefaultCommand(null);
            }
        }
        return this.commandRegistry.executeCommand(context, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] executeCommand(String[] context, String[] cmd, Authenticator authenticator) {
        AuthenticatorHolder.threadLocal.set(authenticator);
        try {
            String[] stringArray = this.executeCommand(context, cmd);
            return stringArray;
        }
        finally {
            AuthenticatorHolder.threadLocal.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJson() {
        this.lock.readLock().lock();
        try {
            StringBuffer s = new StringBuffer();
            s.append("{");
            s.append(this.quote("nodetype")).append(": ");
            s.append(this.quote("root")).append(", ");
            s.append(this.quote("name")).append(": ");
            s.append(this.quote(SwiftletManager.getInstance().getRouterName())).append(", ");
            s.append(this.quote("hasChilds")).append(": ");
            s.append(this.entities != null && this.entities.size() > 0);
            if (this.entities != null) {
                s.append(", ");
                s.append(this.quote("entities")).append(": ");
                s.append("[");
                boolean first = true;
                for (Map.Entry o : this.entities.entrySet()) {
                    if (!first) {
                        s.append(", ");
                    }
                    first = false;
                    Entity e = (Entity)o.getValue();
                    s.append("{");
                    s.append(this.quote("nodetype")).append(": ");
                    if (e instanceof EntityList) {
                        s.append(this.quote("entitylist")).append(", ");
                    } else {
                        s.append(this.quote("entity")).append(", ");
                    }
                    s.append(this.quote("name")).append(": ");
                    s.append(this.quote(e.getName())).append(", ");
                    s.append(this.quote("displayName")).append(": ");
                    s.append(this.quote(e.getDisplayName())).append(", ");
                    s.append(this.quote("description")).append(": ");
                    s.append(this.quote(e.getDescription())).append(", ");
                    s.append(this.quote("hasChilds")).append(": ");
                    s.append(e.getEntities() != null && e.getEntities().size() > 0);
                    s.append("}");
                }
                s.append("]");
            }
            if (this.commandRegistry != null && this.commandRegistry.getCommands() != null) {
                s.append(", ");
                s.append(this.quote("commands")).append(": ");
                s.append("[");
                List cmds = this.commandRegistry.getCommands();
                boolean first = true;
                for (int i = 0; i < cmds.size(); ++i) {
                    Command command = (Command)cmds.get(i);
                    if (!this.commandIncluded(command, new String[]{"help", "sum", "show template"})) continue;
                    if (!first) {
                        s.append(", ");
                    }
                    first = false;
                    s.append(((Command)cmds.get(i)).toJson());
                }
                s.append("]");
            }
            s.append("}");
            String string = s.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

