/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Configuration;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.EntityList;
import com.swiftmq.mgmt.MetaData;
import com.swiftmq.mgmt.MgmtFactory;
import com.swiftmq.mgmt.Property;
import com.swiftmq.tools.util.ObjectCloner;
import com.swiftmq.util.SwiftUtilities;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLUtilities {
    private static HashMap possibleAttr = new HashMap();
    private static HashMap mandatoryAttr = new HashMap();
    private static HashMap possibleEle = new HashMap();
    private static HashMap mandatoryEle = new HashMap();
    private static MgmtFactory factory = new MgmtFactory();

    private static void checkElement(Element element) throws Exception {
        Iterator iter2;
        boolean found;
        Iterator iter;
        HashSet set = (HashSet)possibleAttr.get(element.getName());
        if (set != null) {
            iter = element.attributeIterator();
            while (iter.hasNext()) {
                Attribute a = (Attribute)iter.next();
                if (set.contains(a.getName())) continue;
                throw new Exception("Invalid attribute '" + a.getName() + "' for element '" + element.getName() + "'");
            }
            set = (HashSet)mandatoryAttr.get(element.getName());
            if (set != null) {
                for (String mName : set) {
                    found = false;
                    iter2 = element.attributeIterator();
                    while (iter2.hasNext()) {
                        Attribute a = (Attribute)iter2.next();
                        if (!mName.equals(a.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new Exception("Missing mandatory attribute '" + mName + "' for element '" + element.getName() + "'");
                }
            }
        }
        if ((set = (HashSet)possibleEle.get(element.getName())) != null) {
            iter = element.elementIterator();
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                if (set.contains(e.getName())) continue;
                throw new Exception("Invalid sub-element '" + e.getName() + "' for element '" + element.getName() + "'");
            }
            set = (HashSet)mandatoryEle.get(element.getName());
            if (set != null) {
                for (String mName : set) {
                    found = false;
                    iter2 = element.elementIterator();
                    while (iter2.hasNext()) {
                        Element e = (Element)iter2.next();
                        if (!mName.equals(e.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new Exception("Missing mandatory sub-element '" + mName + "' for element '" + element.getName() + "'");
                }
            }
        }
    }

    private static MetaData createMetaData(Element root) throws Exception {
        XMLUtilities.checkElement(root);
        String name = root.attributeValue("name");
        String displayName = root.attributeValue("displayname");
        String clazz = root.attributeValue("class");
        String description = root.attributeValue("description");
        String release = root.attributeValue("release");
        String vendor = root.attributeValue("vendor");
        MetaData meta = new MetaData(displayName, vendor, release, description);
        meta.setName(name);
        meta.setClassName(clazz);
        return meta;
    }

    private static Property lookupProperty(Entity entity, StringTokenizer t) {
        String name = t.nextToken();
        if (t.hasMoreTokens()) {
            Entity next = entity.getEntity(name);
            if (next == null) {
                return null;
            }
            return XMLUtilities.lookupProperty(next, t);
        }
        return entity.getProperty(name);
    }

    private static void fillEntity(Element element, Entity entity, Entity root) throws Exception {
        Iterator iter = element.elementIterator();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            XMLUtilities.checkElement(e);
            if (e.getName().equals("property")) {
                Property prop = new Property(e.attributeValue("name"));
                prop.setType(Class.forName(e.attributeValue("type")));
                prop.setDisplayName(e.attributeValue("display"));
                prop.setDescription(e.attributeValue("description"));
                String s = e.attributeValue("min");
                if (s != null) {
                    prop.setMinValue((Comparable)Property.convertToType(prop.getType(), s));
                }
                if ((s = e.attributeValue("max")) != null) {
                    prop.setMaxValue((Comparable)Property.convertToType(prop.getType(), s));
                }
                if ((s = e.attributeValue("default")) != null) {
                    prop.setDefaultValue(Property.convertToType(prop.getType(), s));
                }
                if ((s = e.attributeValue("choice")) != null) {
                    ArrayList<String> al = new ArrayList<String>();
                    StringTokenizer t = new StringTokenizer(s, " ");
                    while (t.hasMoreTokens()) {
                        al.add(t.nextToken());
                    }
                    prop.setPossibleValues(al);
                }
                prop.setRebootRequired(Boolean.valueOf(e.attributeValue("reboot-required")));
                prop.setReadOnly(Boolean.valueOf(e.attributeValue("read-only")));
                prop.setMandatory(Boolean.valueOf(e.attributeValue("mandatory")));
                entity.addProperty(prop.getName(), prop);
                continue;
            }
            if (e.getName().equals("entity")) {
                Entity newEntity = new Entity(e.attributeValue("name"), e.attributeValue("display"), e.attributeValue("description"), null);
                newEntity.setIconFilename(e.attributeValue("icon"));
                entity.addEntity(newEntity);
                XMLUtilities.fillEntity(e, newEntity, root);
                continue;
            }
            if (!e.getName().equals("entitylist")) continue;
            Element ltElement = e.element("entitytemplate");
            XMLUtilities.checkElement(ltElement);
            Entity ltEntity = new Entity(ltElement.attributeValue("name"), ltElement.attributeValue("display"), ltElement.attributeValue("description"), null);
            ltEntity.setIconFilename(ltElement.attributeValue("icon"));
            XMLUtilities.fillEntity(ltElement, ltEntity, root);
            EntityList entityList = new EntityList(e.attributeValue("name"), e.attributeValue("display"), e.attributeValue("description"), null, ltEntity, true);
            entityList.setIconFilename(e.attributeValue("icon"));
            String s = e.attributeValue("dynamic-properties");
            if (s != null) {
                ArrayList<String> al = new ArrayList<String>();
                StringTokenizer t = new StringTokenizer(s, " ");
                while (t.hasMoreTokens()) {
                    al.add(0, t.nextToken());
                }
                entityList.setDynamicPropNames(al.toArray(new String[al.size()]));
            }
            entity.addEntity(entityList);
        }
    }

    private static void markDynamic(Entity entity) {
        Map map;
        entity.setDynamic(true);
        Map pm = entity.getProperties();
        if (pm != null) {
            Iterator iter2 = pm.entrySet().iterator();
            while (iter2.hasNext()) {
                Property p = (Property)iter2.next().getValue();
                p.setReadOnly(true);
            }
        }
        if (entity instanceof EntityList) {
            EntityList el = (EntityList)entity;
            XMLUtilities.markDynamic(el.getTemplate());
        }
        if ((map = entity.getEntities()) != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                XMLUtilities.markDynamic(e);
            }
        }
    }

    public static Document createDocument(String xml) throws Exception {
        SAXReader saxReader = new SAXReader();
        return saxReader.read((Reader)new StringReader(xml));
    }

    public static Document createDocument(InputStream in) throws Exception {
        SAXReader saxReader = new SAXReader();
        return saxReader.read(in);
    }

    public static void writeDocument(Document document, String filename) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setLineSeparator(System.getProperty("line.separator"));
        format.setNewlines(true);
        MyXMLWriter writer = new MyXMLWriter(new FileWriter(filename), format);
        writer.write(document);
        writer.flush();
        writer.close();
    }

    public static void writeDocument(Document document, StringWriter stringWriter) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setLineSeparator(System.getProperty("line.separator"));
        format.setNewlines(true);
        MyXMLWriter writer = new MyXMLWriter(stringWriter, format);
        writer.write(document);
        writer.flush();
        writer.close();
    }

    public static Configuration createConfigurationTemplate(String xml) throws Exception {
        Configuration config = null;
        Document doc = XMLUtilities.createDocument(xml);
        Element root = doc.getRootElement();
        if (!root.getName().equals("swiftlet")) {
            throw new Exception("root element must be 'swiftlet', found: " + root.getName());
        }
        config = new Configuration(XMLUtilities.createMetaData(root));
        config.setIconFilename(root.attributeValue("icon"));
        Element configElement = root.element("configuration");
        XMLUtilities.checkElement(configElement);
        XMLUtilities.fillEntity(configElement, config, config);
        Entity usage = config.getEntity("usage");
        if (usage != null) {
            XMLUtilities.markDynamic(usage);
        }
        return config;
    }

    public static List getCLICommands(String xml, String phase) throws Exception {
        Document doc = XMLUtilities.createDocument(xml);
        Element root = doc.getRootElement();
        Element cliElement = root.element("cli");
        if (cliElement == null) {
            return null;
        }
        XMLUtilities.checkElement(cliElement);
        Element phaseElement = cliElement.element(phase);
        if (phaseElement == null || phaseElement.getText() == null || phaseElement.getText().trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(phaseElement.getText(), "\n");
        while (t.hasMoreTokens()) {
            list.add(t.nextToken().trim());
        }
        return list;
    }

    private static String getNodeValue(Element node, String name) throws Exception {
        if (node == null) {
            return null;
        }
        Attribute a = node.attribute(name);
        if (a != null) {
            return a.getValue();
        }
        Element e = node.element(name);
        if (e != null) {
            return e.getText();
        }
        return null;
    }

    private static Property fillProperty(Property template, Element node) throws Exception {
        String s = template.getName();
        String v = XMLUtilities.getNodeValue(node, s);
        if (v == null && template.isMandatory() && template.getDefaultValue() == null) {
            throw new Exception("Missing mandatory property: " + s + " (no default value given)");
        }
        Property p = null;
        try {
            p = (Property)ObjectCloner.copy(template, factory);
            if (v == null) {
                p.setValue(p.getDefaultValue());
            } else {
                Object value = v;
                Class type = p.getType();
                if (type == Boolean.class) {
                    value = Boolean.valueOf(v);
                } else if (type == Integer.class) {
                    value = Integer.valueOf(v);
                } else if (type == Long.class) {
                    value = Long.valueOf(v);
                } else if (type == Double.class) {
                    value = Double.valueOf(v);
                } else if (type == Float.class) {
                    value = Float.valueOf(v);
                }
                p.setValue(value);
            }
        }
        catch (Exception e) {
            throw new Exception("Exception occurred while creating property '" + s + "': " + String.valueOf(e));
        }
        return p;
    }

    private static EntityList fillEntityList(EntityList listTemplate, Element node) throws Exception {
        Entity template = listTemplate.getTemplate();
        if (template == null) {
            throw new Exception("Missing entity template for entity list: " + listTemplate.getName());
        }
        EntityList list = (EntityList)ObjectCloner.copy(listTemplate, factory);
        if (!list.isDynamic() && node != null) {
            Iterator iter = node.elementIterator();
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                if (!e.getName().equals(template.getName())) {
                    throw new Exception("Invalid element found: " + e.getName() + ", expected: " + template.getName());
                }
                Entity entry = XMLUtilities.fillEntity(template, e);
                String name = e.attributeValue("name");
                if (name == null) {
                    throw new Exception("Missing 'name' attribute for element: " + e.getName());
                }
                entry.setName(name);
                list.addEntity(entry);
            }
        }
        list.createCommands();
        if (node != null) {
            list.setUpgrade(node.attribute("_upgrade") != null);
        }
        return list;
    }

    private static Entity fillEntity(Entity template, Element node) throws Exception {
        Iterator iter;
        Entity entity = (Entity)ObjectCloner.copy(template, factory);
        Map m = template.getProperties();
        if (m.size() > 0) {
            iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Property p = (Property)iter.next().getValue();
                Property pn = XMLUtilities.fillProperty(p, node);
                if (pn == null) continue;
                entity.addProperty(pn.getName(), pn);
            }
        }
        if ((m = template.getEntities()).size() > 0) {
            iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                if (e instanceof EntityList) {
                    entity.addEntity(XMLUtilities.fillEntityList((EntityList)e, node == null ? null : node.element(e.getName())));
                    continue;
                }
                entity.addEntity(XMLUtilities.fillEntity(e, node == null ? null : node.element(e.getName())));
            }
        }
        entity.createCommands();
        if (node != null) {
            entity.setUpgrade(node.attribute("_upgrade") != null);
        }
        return entity;
    }

    public static void loadIcons(Entity entity, ClassLoader loader) throws Exception {
        Map m;
        String fn = entity.getIconFilename();
        if (fn != null) {
            InputStream in = loader.getResourceAsStream(fn);
            if (in == null && fn.startsWith("/")) {
                in = loader.getResourceAsStream(fn.substring(1));
            }
            if (in != null) {
                entity.setImageArray(SwiftUtilities.loadImageAsBytes(in));
            }
        }
        if ((m = entity.getEntities()) != null) {
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                XMLUtilities.loadIcons(e, loader);
                if (!(e instanceof EntityList)) continue;
                XMLUtilities.loadIcons(((EntityList)e).getTemplate(), loader);
            }
        }
    }

    public static Element getSwiftletElement(String searched, Element root) throws Exception {
        Iterator iter = root.elementIterator();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            if (!e.getName().equals("swiftlet")) continue;
            String name = e.attributeValue("name");
            if (name == null) {
                throw new Exception("Missing 'name' attribute for element: " + e.getName());
            }
            if (!name.equals(searched)) continue;
            return e;
        }
        return null;
    }

    public static Configuration fillConfiguration(Configuration template, String xml) throws Exception {
        return XMLUtilities.fillConfiguration(template, XMLUtilities.createDocument(xml));
    }

    public static Configuration fillConfiguration(Configuration template, Document doc) throws Exception {
        Element root = doc.getRootElement();
        MetaData meta = template.getMetaData();
        Element swiftletNode = XMLUtilities.getSwiftletElement(meta.getName(), root);
        Configuration config = null;
        if (swiftletNode == null) {
            config = (Configuration)ObjectCloner.copy(template, factory);
            config.createCommands();
        } else {
            config = (Configuration)XMLUtilities.fillEntity(template, swiftletNode);
        }
        config.setMetaData(meta);
        return config;
    }

    private static void fillAttributes(Element node, Entity entity, boolean addName) throws Exception {
        Map m;
        if (addName) {
            node.addAttribute("name", entity.getName());
        }
        if ((m = entity.getProperties()) != null) {
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Property p = (Property)iter.next().getValue();
                if (!p.isStorable() || p.getValue() == null || (p.getDefaultValue() == null || p.getValue().equals(p.getDefaultValue())) && p.getDefaultValue() != null) continue;
                node.addAttribute(p.getName(), p.getValue().toString());
            }
        }
    }

    public static void entityToXML(Element parent, String tagName, Entity entity, boolean addName) throws Exception {
        Element node = DocumentHelper.createElement((String)(addName ? tagName : entity.getName()));
        XMLUtilities.fillAttributes(node, entity, addName);
        Map m = entity.getEntities();
        if (m != null) {
            String tplTagName = entity.getName();
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                if (e instanceof EntityList) {
                    XMLUtilities.entityListToXML(node, tplTagName, (EntityList)e);
                    continue;
                }
                XMLUtilities.entityToXML(node, tplTagName, e, false);
            }
        }
        parent.add(node);
    }

    private static void entityListToXML(Element parent, String tagName, EntityList entity) throws Exception {
        Element node = DocumentHelper.createElement((String)entity.getName());
        XMLUtilities.fillAttributes(node, entity, false);
        Map m = entity.getEntities();
        if (m != null) {
            String tplTagName = entity.getTemplate().getName();
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                if (e instanceof EntityList) {
                    XMLUtilities.entityListToXML(node, tplTagName, (EntityList)e);
                    continue;
                }
                XMLUtilities.entityToXML(node, tplTagName, e, true);
            }
        }
        parent.add(node);
    }

    public static void configToXML(Configuration config, Element root) throws Exception {
        MetaData meta = config.getMetaData();
        root.add(DocumentHelper.createComment((String)("  " + meta.getDisplayName() + ", Release: " + meta.getVersion() + "  ")));
        Element node = DocumentHelper.createElement((String)"swiftlet");
        XMLUtilities.fillAttributes(node, config, true);
        Map m = config.getEntities();
        if (m != null) {
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                if (e.getName().equals(".metadata") || e.isDynamic()) continue;
                if (e instanceof EntityList) {
                    XMLUtilities.entityListToXML(node, e.getName(), (EntityList)e);
                    continue;
                }
                XMLUtilities.entityToXML(node, e.getName(), e, false);
            }
        }
        root.add(node);
    }

    public static void elementToXML(Element ele, Element root) throws Exception {
        Element node = DocumentHelper.createElement((String)ele.getName());
        Iterator iter = ele.attributeIterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            node.addAttribute(attr.getName(), attr.getValue());
        }
        iter = ele.elementIterator();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            XMLUtilities.elementToXML(e, node);
        }
        root.add(node);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("name");
        set.add("displayname");
        set.add("class");
        set.add("icon");
        set.add("description");
        set.add("release");
        set.add("vendor");
        possibleAttr.put("swiftlet", set);
        set = new HashSet();
        set.add("name");
        set.add("displayname");
        set.add("class");
        set.add("description");
        set.add("release");
        set.add("vendor");
        mandatoryAttr.put("swiftlet", set);
        set = new HashSet();
        set.add("configuration");
        set.add("cli");
        possibleEle.put("swiftlet", set);
        set = new HashSet();
        set.add("configuration");
        mandatoryEle.put("swiftlet", set);
        set = new HashSet();
        set.add("property");
        set.add("entity");
        set.add("entitylist");
        possibleEle.put("configuration", set);
        set = new HashSet();
        set.add("property");
        set.add("entity");
        set.add("entitylist");
        possibleEle.put("usage", set);
        set = new HashSet();
        set.add("name");
        set.add("display");
        set.add("description");
        set.add("type");
        set.add("min");
        set.add("max");
        set.add("default");
        set.add("choice");
        set.add("mandatory");
        set.add("reboot-required");
        set.add("read-only");
        possibleAttr.put("property", set);
        set = new HashSet();
        set.add("name");
        set.add("display");
        set.add("description");
        set.add("type");
        mandatoryAttr.put("property", set);
        set = new HashSet();
        set.add("name");
        set.add("display");
        set.add("description");
        set.add("icon");
        possibleAttr.put("entity", set);
        set = new HashSet();
        set.add("name");
        set.add("display");
        set.add("description");
        mandatoryAttr.put("entity", set);
        set = new HashSet();
        set.add("property");
        set.add("entity");
        set.add("entitylist");
        possibleEle.put("entity", set);
        set = new HashSet();
        set.add("name");
        set.add("display");
        set.add("description");
        set.add("icon");
        set.add("dynamic-properties");
        possibleAttr.put("entitylist", set);
        set = new HashSet();
        set.add("name");
        set.add("display");
        set.add("description");
        mandatoryAttr.put("entitylist", set);
        set = new HashSet();
        set.add("entitytemplate");
        possibleEle.put("entitylist", set);
        set = new HashSet();
        set.add("entitytemplate");
        mandatoryEle.put("entitylist", set);
        set = new HashSet();
        set.add("before-install");
        set.add("after-remove");
        possibleEle.put("cli", set);
    }

    private static class MyXMLWriter
    extends XMLWriter {
        public MyXMLWriter(Writer writer, OutputFormat format) {
            super(writer, format);
        }

        protected void writeComment(String text) throws IOException {
            this.writePrintln();
            super.writeComment(text);
        }
    }
}

