/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt.protocol.v750;

import com.swiftmq.mgmt.protocol.v750.ProtocolFactory;
import com.swiftmq.mgmt.protocol.v750.ProtocolVisitor;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.DumpableFactory;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BulkRequest
extends Request {
    public DumpableFactory factory = new ProtocolFactory();
    public Object[] dumpables = null;
    public int len = 0;

    public BulkRequest() {
        super(0, false);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.len);
        for (int i = 0; i < this.len; ++i) {
            Dumpalizer.dump(out, (Dumpable)this.dumpables[i]);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.len = in.readInt();
        this.dumpables = new Object[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.dumpables[i] = Dumpalizer.construct(in, this.factory);
        }
    }

    @Override
    public int getDumpId() {
        return 102;
    }

    @Override
    protected Reply createReplyInstance() {
        return null;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    private String dumpDumpables() {
        StringBuffer b = new StringBuffer("\n");
        for (int i = 0; i < this.len; ++i) {
            b.append(this.dumpables[i].toString());
            b.append("\n");
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[BulkRequest " + super.toString() + " len =" + this.len + " dumpables=" + this.dumpDumpables() + "]";
    }
}

