/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt.protocol.v750;

import com.swiftmq.mgmt.protocol.v750.CommandReply;
import com.swiftmq.mgmt.protocol.v750.ProtocolVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CommandRequest
extends Request {
    boolean internal = false;
    String[] context = null;
    String[] command = null;

    public CommandRequest(String[] context, String[] command, boolean internal) {
        super(0, true);
        this.context = context;
        this.command = command;
        this.internal = internal;
    }

    public CommandRequest() {
        this(null, null, false);
    }

    public String[] getContext() {
        return this.context;
    }

    public void setContext(String[] context) {
        this.context = context;
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    @Override
    public int getDumpId() {
        return 103;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        int i;
        super.writeContent(out);
        out.writeBoolean(this.internal);
        if (this.context != null) {
            out.writeByte(1);
            out.writeInt(this.context.length);
            for (i = 0; i < this.context.length; ++i) {
                out.writeUTF(this.context[i]);
            }
        } else {
            out.writeByte(0);
        }
        out.writeInt(this.command.length);
        for (i = 0; i < this.command.length; ++i) {
            out.writeUTF(this.command[i]);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        int i;
        super.readContent(in);
        this.internal = in.readBoolean();
        byte set = in.readByte();
        if (set == 1) {
            this.context = new String[in.readInt()];
            for (i = 0; i < this.context.length; ++i) {
                this.context[i] = in.readUTF();
            }
        }
        this.command = new String[in.readInt()];
        for (i = 0; i < this.command.length; ++i) {
            this.command[i] = in.readUTF();
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new CommandReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        return "[CommandRequest " + super.toString() + ", context=" + (this.context != null ? SwiftUtilities.concat(this.context, "/") : "null") + ", command=" + SwiftUtilities.concat(this.command, " ") + ", internal=" + this.internal + "]";
    }
}

