/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt.protocol.v750;

import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ConnectReply
extends Reply {
    String routerName = null;
    boolean authRequired = false;
    String crFactory = null;
    Serializable challenge = null;
    long leaseTimeout = 0L;

    public ConnectReply(String routerName, boolean authRequired, String crFactory, Serializable challenge, long leaseTimeout) {
        this.routerName = routerName;
        this.authRequired = authRequired;
        this.crFactory = crFactory;
        this.challenge = challenge;
        this.leaseTimeout = leaseTimeout;
    }

    public ConnectReply() {
    }

    public String getRouterName() {
        return this.routerName;
    }

    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
    }

    public String getCrFactory() {
        return this.crFactory;
    }

    public void setCrFactory(String crFactory) {
        this.crFactory = crFactory;
    }

    public Serializable getChallenge() {
        return this.challenge;
    }

    public void setChallenge(Serializable challenge) {
        this.challenge = challenge;
    }

    public long getLeaseTimeout() {
        return this.leaseTimeout;
    }

    public void setLeaseTimeout(long leaseTimeout) {
        this.leaseTimeout = leaseTimeout;
    }

    @Override
    public int getDumpId() {
        return 106;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeUTF(this.routerName);
        out.writeBoolean(this.authRequired);
        if (this.authRequired) {
            out.writeUTF(this.crFactory);
            DataByteArrayOutputStream dbos = new DataByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(dbos);
            oos.writeObject(this.challenge);
            oos.flush();
            oos.close();
            out.writeInt(dbos.getCount());
            out.write(dbos.getBuffer(), 0, dbos.getCount());
        }
        out.writeLong(this.leaseTimeout);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.routerName = in.readUTF();
        this.authRequired = in.readBoolean();
        if (this.authRequired) {
            this.crFactory = in.readUTF();
            byte[] b = new byte[in.readInt()];
            in.readFully(b);
            DataByteArrayInputStream dbis = new DataByteArrayInputStream(b);
            ObjectInputStream ois = new ObjectInputStream(dbis);
            try {
                this.challenge = (Serializable)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.toString());
            }
            ois.close();
        }
        this.leaseTimeout = in.readLong();
    }

    @Override
    public String toString() {
        return "[ConnectReply " + super.toString() + ", routerName=" + this.routerName + ", authRequired=" + this.authRequired + ", crFactory=" + this.crFactory + ", challenge=" + String.valueOf(this.challenge) + ", leaseTimeout=" + this.leaseTimeout + "]";
    }
}

