/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt.protocol.v750;

import com.swiftmq.mgmt.protocol.v750.ProtocolVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EntityListClearRequest
extends Request {
    String[] context = null;

    public EntityListClearRequest(String[] context) {
        super(0, false);
        this.context = context;
    }

    public EntityListClearRequest() {
        this(null);
    }

    public String[] getContext() {
        return this.context;
    }

    public void setContext(String[] context) {
        this.context = context;
    }

    @Override
    public int getDumpId() {
        return 119;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.context != null) {
            out.writeByte(1);
            out.writeInt(this.context.length);
            for (int i = 0; i < this.context.length; ++i) {
                out.writeUTF(this.context[i]);
            }
        } else {
            out.writeByte(0);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        if (set == 1) {
            this.context = new String[in.readInt()];
            for (int i = 0; i < this.context.length; ++i) {
                this.context[i] = in.readUTF();
            }
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return null;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        return "[EntityListClearRequest " + super.toString() + ", context=" + (this.context != null ? SwiftUtilities.concat(this.context, "/") : "null") + "]";
    }
}

