/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt.protocol.v750;

import com.swiftmq.mgmt.protocol.v750.ProtocolVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SetSubscriptionFilterRequest
extends Request {
    String[] context = null;
    boolean includeNextLevel = false;

    SetSubscriptionFilterRequest() {
        this(null, false);
    }

    public SetSubscriptionFilterRequest(String[] context, boolean includeNextLevel) {
        super(0, false);
        this.context = context;
        this.includeNextLevel = includeNextLevel;
    }

    @Override
    public int getDumpId() {
        return 117;
    }

    @Override
    public void writeContent(DataOutput output) throws IOException {
        super.writeContent(output);
        output.writeBoolean(this.includeNextLevel);
        output.writeInt(this.context.length);
        for (int i = 0; i < this.context.length; ++i) {
            output.writeUTF(this.context[i]);
        }
    }

    @Override
    public void readContent(DataInput input) throws IOException {
        super.readContent(input);
        this.includeNextLevel = input.readBoolean();
        int len = input.readInt();
        this.context = new String[len];
        for (int i = 0; i < len; ++i) {
            this.context[i] = input.readUTF();
        }
    }

    public String[] getContext() {
        return this.context;
    }

    public void setContext(String[] context) {
        this.context = context;
    }

    public boolean isIncludeNextLevel() {
        return this.includeNextLevel;
    }

    public void setIncludeNextLevel(boolean includeNextLevel) {
        this.includeNextLevel = includeNextLevel;
    }

    @Override
    protected Reply createReplyInstance() {
        return null;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        return "[SetSubscriptionFilterRequest " + super.toString() + ", context=" + SwiftUtilities.concat(this.context, "/") + ", includeNextLevel=" + this.includeNextLevel + "]";
    }
}

