/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.ms.artemis;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.ms.artemis.filter.BooleanExpression;
import com.swiftmq.ms.artemis.filter.FilterException;
import com.swiftmq.ms.artemis.filter.Filterable;
import com.swiftmq.ms.artemis.impl.SelectorParser;
import com.swiftmq.ms.artemis.util.SimpleString;
import com.swiftmq.swiftlet.queue.Selector;
import jakarta.jms.InvalidSelectorException;

public class MessageSelector
implements Selector,
Filterable {
    String conditionString;
    MessageImpl current;

    public MessageSelector(String conditionString) {
        this.conditionString = conditionString;
    }

    @Override
    public String getConditionString() {
        return this.conditionString;
    }

    public void compile() throws InvalidSelectorException {
        try {
            SelectorParser.parse(this.conditionString);
        }
        catch (Throwable t) {
            String s = t.getMessage();
            if (s == null || s.length() == 0) {
                s = "Invalid selector";
            }
            throw new InvalidSelectorException("<" + this.conditionString + ">: " + s);
        }
    }

    @Override
    public boolean isSelected(MessageImpl message) {
        this.current = message;
        try {
            BooleanExpression selector = SelectorParser.parse(this.conditionString);
            if (selector != null) {
                return selector.matches(this);
            }
        }
        catch (FilterException e) {
            return false;
        }
        return false;
    }

    @Override
    public <T> T getBodyAs(Class<T> aClass) throws FilterException {
        return null;
    }

    @Override
    public Object getProperty(SimpleString simpleString) {
        return this.current.getField(simpleString.toString());
    }

    @Override
    public Object getLocalConnectionId() {
        return null;
    }
}

