/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.ms.artemis.filter;

import com.swiftmq.ms.artemis.filter.Expression;

public abstract class BinaryExpression
implements Expression {
    protected Expression left;
    protected Expression right;

    public BinaryExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public String toString() {
        return "(" + this.left.toString() + " " + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        result = 31 * result + this.getExpressionSymbol().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        if (!this.getExpressionSymbol().equals(that.getExpressionSymbol())) {
            return false;
        }
        if (this.left != null && !this.left.equals(that.left)) {
            return false;
        }
        return this.right == null || this.right.equals(that.right);
    }

    public abstract String getExpressionSymbol();

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public void setLeft(Expression expression) {
        this.left = expression;
    }
}

