/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.ms.artemis.filter;

import com.swiftmq.ms.artemis.filter.BooleanExpression;
import com.swiftmq.ms.artemis.filter.Expression;
import com.swiftmq.ms.artemis.filter.FilterException;
import com.swiftmq.ms.artemis.filter.Filterable;
import com.swiftmq.ms.artemis.filter.PropertyExpression;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class UnaryExpression
implements Expression {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression right;

    public UnaryExpression(Expression left) {
        this.right = left;
    }

    public static Expression createNegate(Expression left) {
        return new UnaryExpression(left){

            @Override
            public Object evaluate(Filterable message) throws FilterException {
                Object rvalue = this.right.evaluate(message);
                if (rvalue == null) {
                    return null;
                }
                if (rvalue instanceof Number) {
                    return UnaryExpression.negate((Number)rvalue);
                }
                return null;
            }

            @Override
            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static BooleanExpression createInExpression(PropertyExpression right, List<Object> elements, final boolean not) {
        final Collection<Object> inList = elements.size() < 5 ? elements : new HashSet<Object>(elements);
        return new BooleanUnaryExpression(right){

            @Override
            public Object evaluate(Filterable message) throws FilterException {
                Object rvalue = this.right.evaluate(message);
                if (rvalue == null) {
                    return null;
                }
                if (rvalue.getClass() != String.class) {
                    return null;
                }
                return inList.contains(rvalue) ^ not;
            }

            @Override
            public String toString() {
                StringBuffer answer = new StringBuffer();
                answer.append(this.right);
                answer.append(" ");
                answer.append(this.getExpressionSymbol());
                answer.append(" ( ");
                int count = 0;
                for (Object o : inList) {
                    if (count != 0) {
                        answer.append(", ");
                    }
                    answer.append(o);
                    ++count;
                }
                answer.append(" )");
                return answer.toString();
            }

            @Override
            public String getExpressionSymbol() {
                if (not) {
                    return "NOT IN";
                }
                return "IN";
            }
        };
    }

    public static BooleanExpression createNOT(BooleanExpression left) {
        return new BooleanUnaryExpression(left){

            @Override
            public Object evaluate(Filterable message) throws FilterException {
                Boolean lvalue = (Boolean)this.right.evaluate(message);
                if (lvalue == null) {
                    return null;
                }
                return lvalue == false;
            }

            @Override
            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    public static BooleanExpression createBooleanCast(Expression left) {
        return new BooleanUnaryExpression(left){

            @Override
            public Object evaluate(Filterable message) throws FilterException {
                Object rvalue = this.right.evaluate(message);
                if (rvalue == null) {
                    return null;
                }
                if (!rvalue.getClass().equals(Boolean.class)) {
                    return Boolean.FALSE;
                }
                return (boolean)((Boolean)rvalue);
            }

            @Override
            public String toString() {
                return this.right.toString();
            }

            @Override
            public String getExpressionSymbol() {
                return "";
            }
        };
    }

    private static Number negate(Number left) {
        Class<?> clazz = left.getClass();
        if (clazz == Integer.class) {
            return -left.intValue();
        }
        if (clazz == Long.class) {
            return -left.longValue();
        }
        if (clazz == Float.class) {
            return Float.valueOf(-left.floatValue());
        }
        if (clazz == Double.class) {
            return -left.doubleValue();
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)left;
            if (BD_LONG_MIN_VALUE.compareTo(bd = bd.negate()) == 0) {
                return Long.MIN_VALUE;
            }
            return bd;
        }
        throw new RuntimeException("Don't know how to negate: " + String.valueOf(left));
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        int result = this.right.hashCode();
        result = 31 * result + this.getExpressionSymbol().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)o;
        if (!this.getExpressionSymbol().equals(that.getExpressionSymbol())) {
            return false;
        }
        return this.right == null || this.right.equals(that.right);
    }

    public abstract String getExpressionSymbol();

    static abstract class BooleanUnaryExpression
    extends UnaryExpression
    implements BooleanExpression {
        BooleanUnaryExpression(Expression left) {
            super(left);
        }

        @Override
        public boolean matches(Filterable message) throws FilterException {
            Object object = this.evaluate(message);
            return object == Boolean.TRUE;
        }
    }
}

