/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net;

import com.swiftmq.tools.prop.StructuredProperties;
import com.swiftmq.tools.prop.SystemProperties;
import com.swiftmq.tools.sql.LikeComparator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Properties;
import java.util.StringTokenizer;

public class HttpTunnelProperties
implements Serializable {
    public static final String PROP_FILENAME_PROP = "swiftmq.httptunnel.file";
    public static final String PROP_DEBUG = "swiftmq.httptunnel.debug";
    public static final String PROP_FILENAME = "/httptunnel.properties";
    public static final String PROP_PROXY_HOST = "proxy.host";
    public static final String PROP_PROXY_PORT = "proxy.port";
    public static final String PROP_PROXY_USERNAME = "proxy.username";
    public static final String PROP_PROXY_PASSWORD = "proxy.password";
    public static final String PROP_NO_PROXY_HOST = "noproxy.host";
    private String proxyHost = null;
    private int proxyPort = -1;
    private String username = null;
    private String password = null;
    private String[] excludeList = null;
    private boolean debug = false;

    private HttpTunnelProperties() {
        try {
            String sdebug = SystemProperties.get(PROP_DEBUG);
            this.debug = sdebug != null && sdebug.equals("true");
            InputStream in = null;
            String filename = SystemProperties.get(PROP_FILENAME_PROP);
            this.debug("Property filename = " + filename);
            in = filename != null ? new FileInputStream(filename) : HttpTunnelProperties.class.getResourceAsStream(PROP_FILENAME);
            this.debug(in == null ? "No property file found, HttpTunneling disabled" : "Property file found, HttpTunneling enabled");
            if (in == null) {
                return;
            }
            Properties prop = new Properties();
            prop.load(in);
            in.close();
            this.debug("Properties = " + String.valueOf(prop));
            StructuredProperties sp = new StructuredProperties(prop);
            this.proxyHost = prop.getProperty(PROP_PROXY_HOST);
            this.proxyPort = Integer.parseInt(prop.getProperty(PROP_PROXY_PORT));
            this.excludeList = sp.getSectionElements(PROP_NO_PROXY_HOST);
            this.username = prop.getProperty(PROP_PROXY_USERNAME);
            this.password = prop.getProperty(PROP_PROXY_PASSWORD);
        }
        catch (Exception e) {
            System.err.println("Exception during load of httptunnel properties: " + String.valueOf(e));
        }
    }

    public static HttpTunnelProperties getInstance() {
        return InstanceHolder.instance;
    }

    private void debug(String msg) {
        if (this.debug) {
            System.out.println("HttpTunneling: " + msg);
        }
    }

    public void clear() {
        this.proxyHost = null;
        this.proxyPort = -1;
        this.username = null;
        this.password = null;
        this.excludeList = null;
    }

    public void reload(Properties prop) {
        if (this.debug) {
            System.out.println("reload: " + String.valueOf(prop));
        }
        this.clear();
        if (prop != null && prop.size() > 0) {
            StructuredProperties sp = new StructuredProperties(prop);
            this.proxyHost = prop.getProperty(PROP_PROXY_HOST);
            this.proxyPort = Integer.parseInt(prop.getProperty(PROP_PROXY_PORT));
            this.excludeList = sp.getSectionElements(PROP_NO_PROXY_HOST);
            this.username = prop.getProperty(PROP_PROXY_USERNAME);
            this.password = prop.getProperty(PROP_PROXY_PASSWORD);
        }
    }

    public void reload(String filename) throws IOException {
        FileInputStream in;
        if (this.debug) {
            System.out.println("reload from file: " + filename);
        }
        if ((in = new FileInputStream(filename)) == null) {
            throw new FileNotFoundException(filename);
        }
        Properties prop = new Properties();
        prop.load(in);
        this.reload(prop);
        in.close();
    }

    public boolean isProxy() {
        return this.proxyHost != null && this.proxyPort != -1;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean isHostViaProxy(String hostname) {
        this.debug("Checking, if host '" + hostname + "' goes through the proxy ...");
        if (this.excludeList == null) {
            this.debug("Yes (no exclude list defined)");
            return true;
        }
        for (int i = 0; i < this.excludeList.length; ++i) {
            if (!LikeComparator.compare(hostname, this.excludeList[i], '\\')) continue;
            this.debug("No (matches for entry '" + this.excludeList[i] + "')");
            return false;
        }
        this.debug("Yes (does not match any entry in the exclude list)");
        return true;
    }

    public void setupHttpProxy(String host, int port, InputStream socketInputStream, OutputStream socketOutputStream) throws IOException {
        int c;
        StringBuffer b = new StringBuffer("CONNECT ");
        b.append(host);
        b.append(':');
        b.append(port);
        b.append(" HTTP/1.0\r\nUser-Agent: SwiftMQ JMS Enterprise Messaging System\r\n");
        if (this.username != null) {
            b.append("Proxy-Authorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes()) + "\r\n");
        }
        b.append("\r\n");
        this.debug("Sending to proxy: \n" + b.toString());
        socketOutputStream.write(b.toString().getBytes());
        socketOutputStream.flush();
        Object s = new String();
        while ((c = socketInputStream.read()) != -1 && !((String)(s = (String)s + String.valueOf((char)c))).endsWith("\r\n\r\n")) {
        }
        this.debug("Receiving from proxy: \n" + (String)s);
        StringTokenizer t = new StringTokenizer((String)s);
        t.nextToken();
        String code = t.nextToken();
        if (code.equals("200")) {
            this.debug("Response from proxy is 200; tunneling starts ...");
            return;
        }
        this.debug("Response from proxy is != 200; throwing exception");
        throw new IOException("Error during proxy setup. Proxy responds with:\n" + (String)s);
    }

    private static class InstanceHolder {
        public static HttpTunnelProperties instance = new HttpTunnelProperties();

        private InstanceHolder() {
        }
    }
}

