/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.client;

import com.swiftmq.net.client.Connection;
import com.swiftmq.net.client.ExceptionHandler;
import com.swiftmq.net.client.InboundHandler;
import com.swiftmq.net.protocol.ChunkListener;
import com.swiftmq.net.protocol.OutputListener;
import com.swiftmq.net.protocol.ProtocolInputHandler;
import com.swiftmq.net.protocol.ProtocolOutputHandler;
import com.swiftmq.net.protocol.smqp.SMQPInputHandler;
import com.swiftmq.net.protocol.smqp.SMQPOutputHandler;
import com.swiftmq.tools.prop.SystemProperties;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BlockingConnection
extends Thread
implements Connection,
ChunkListener,
OutputListener {
    static final boolean ISDAEMON = Boolean.valueOf(SystemProperties.get("swiftmq.socket.reader.isdaemon", "false"));
    static final boolean SET_SOCKET_OPTIONS = Boolean.valueOf(SystemProperties.get("swiftmq.socket.set.options", "true"));
    static final int MAX_SNDBUFSIZE = Integer.parseInt(SystemProperties.get("swiftmq.socket.max.sendbuffersize", "0"));
    static final int MAX_RCVBUFSIZE = Integer.parseInt(SystemProperties.get("swiftmq.socket.max.receivebuffersize", "0"));
    static final int SO_TIMEOUT = Integer.parseInt(SystemProperties.get("swiftmq.socket.sotimeout", "0"));
    Socket socket = null;
    int inputBufferSize = 0;
    int inputExtendSize = 0;
    int outputBufferSize = 0;
    int outputExtendSize = 0;
    ProtocolInputHandler inputHandler = null;
    ProtocolOutputHandler outputHandler = null;
    DataByteArrayInputStream dis = null;
    InboundHandler inboundHandler = null;
    ExceptionHandler exceptionHandler = null;
    InputStream socketIn = null;
    OutputStream socketOut = null;
    String myHostname = null;
    boolean closed = false;
    int sndBufferSize = 8192;
    AtomicBoolean inputActiveIndicator = null;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public BlockingConnection(Socket socket, InboundHandler inboundHandler, ExceptionHandler exceptionHandler) throws IOException {
        this(socket, 131072, 65536, 131072, 65536);
        this.inboundHandler = inboundHandler;
        this.exceptionHandler = exceptionHandler;
    }

    public BlockingConnection(Socket socket, int inputBufferSize, int inputExtendSize, int outputBufferSize, int outputExtendSize) throws IOException {
        this.socket = socket;
        this.setDaemon(ISDAEMON);
        if (SET_SOCKET_OPTIONS) {
            int n = outputBufferSize;
            try {
                if (MAX_SNDBUFSIZE > 0) {
                    n = Math.min(outputBufferSize, MAX_SNDBUFSIZE);
                }
                socket.setSendBufferSize(n);
                this.sndBufferSize = socket.getSendBufferSize();
            }
            catch (SocketException e) {
                System.err.println("Unable to perform 'socket.setSendBufferSize(" + n + ")', exception: " + String.valueOf(e));
            }
            try {
                n = inputBufferSize;
                if (MAX_RCVBUFSIZE > 0) {
                    n = Math.min(inputBufferSize, MAX_RCVBUFSIZE);
                }
                if (socket.getReceiveBufferSize() != n) {
                    socket.setReceiveBufferSize(n);
                }
            }
            catch (SocketException e) {
                System.err.println("Unable to perform 'socket.setReceiveBufferSize(" + n + ")', exception: " + String.valueOf(e));
            }
        }
        if (SO_TIMEOUT > 0) {
            try {
                socket.setSoTimeout(SO_TIMEOUT);
            }
            catch (SocketException e) {
                System.err.println("Unable to perform 'socket.setSoTimeout(" + SO_TIMEOUT + ")', exception: " + String.valueOf(e));
            }
        }
        this.inputBufferSize = inputBufferSize;
        this.inputExtendSize = inputExtendSize;
        this.outputBufferSize = outputBufferSize;
        this.outputExtendSize = outputExtendSize;
        this.outputHandler = this.createOutputHandler(outputBufferSize, outputExtendSize);
        this.outputHandler.setOutputListener(this);
        this.inputHandler = this.createInputHandler();
        this.inputHandler.createInputBuffer(inputBufferSize, inputExtendSize);
        this.inputHandler.setChunkListener(this);
        this.dis = new DataByteArrayInputStream();
        this.socketIn = socket.getInputStream();
        this.socketOut = socket.getOutputStream();
        try {
            this.myHostname = socket.getLocalAddress().toString();
        }
        catch (Exception e) {
            this.myHostname = "unknown";
        }
    }

    protected ProtocolOutputHandler createOutputHandler(int outputBufferSize, int outputExtendSize) {
        return new SMQPOutputHandler(outputBufferSize, outputExtendSize){

            @Override
            public void flush() throws IOException {
                super.flush();
                this.invokeOutputListener();
            }
        };
    }

    protected ProtocolInputHandler createInputHandler() {
        return new SMQPInputHandler();
    }

    @Override
    public void setInputActiveIndicator(AtomicBoolean inputActiveIndicator) {
        this.inputActiveIndicator = inputActiveIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chunkCompleted(byte[] b, int offset, int len) {
        this.lock.writeLock().lock();
        try {
            this.dis.setBuffer(b, offset, len);
            this.inboundHandler.dataAvailable(this.dis);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int performWrite(byte[] b, int offset, int len) throws IOException {
        this.socketOut.write(b, offset, len);
        this.socketOut.flush();
        return len;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.closed) {
                byte[] buffer = this.inputHandler.getBuffer();
                int offset = this.inputHandler.getOffset();
                try {
                    int n = this.socketIn.read(buffer, offset, buffer.length - offset);
                    if (n > 0) {
                        if (this.inputActiveIndicator != null) {
                            this.inputActiveIndicator.set(true);
                        }
                        this.inputHandler.setBytesWritten(n);
                    }
                    if (n != -1) continue;
                    throw new IOException("End-of-Stream reached");
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
            }
            return;
        }
        catch (IOException e) {
            if (this.closed || this.exceptionHandler == null) return;
            this.exceptionHandler.onException(e);
        }
    }

    @Override
    public void setInboundHandler(InboundHandler inboundHandler) {
        this.lock.writeLock().lock();
        try {
            this.inboundHandler = inboundHandler;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public String getLocalHostname() {
        return this.myHostname;
    }

    @Override
    public String getHostname() {
        return this.socket.getInetAddress().getHostName();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputHandler;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return "[BlockingConnection, socket=" + String.valueOf(this.socket) + "]";
    }
}

