/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.client;

import com.swiftmq.net.SocketFactory;
import com.swiftmq.net.client.BlockingConnection;
import com.swiftmq.net.client.Connection;
import com.swiftmq.net.client.Reconnector;
import com.swiftmq.net.client.ServerEntry;
import java.net.Socket;
import java.util.List;
import java.util.Map;

public class BlockingReconnector
extends Reconnector {
    public BlockingReconnector(List servers, Map parameters, boolean enabled, int maxRetries, long retryDelay, boolean debug) {
        super(servers, parameters, enabled, maxRetries, retryDelay, debug);
    }

    @Override
    protected Connection createConnection(ServerEntry entry, Map parameters) {
        BlockingConnection connection;
        block2: {
            connection = null;
            try {
                boolean tcpNoDelay = (Boolean)parameters.get("tcp_no_delay");
                int inputBufferSize = (Integer)parameters.get("input_buffer_size");
                int inputExtendSize = (Integer)parameters.get("input_extend_size");
                int outputBufferSize = (Integer)parameters.get("output_buffer_size");
                int outputExtendSize = (Integer)parameters.get("output_extend_size");
                SocketFactory socketFactory = (SocketFactory)parameters.get("socketfactory");
                Socket socket = socketFactory.createSocket(entry.getHostname(), entry.getPort(), tcpNoDelay);
                connection = new BlockingConnection(socket, inputBufferSize, inputExtendSize, outputBufferSize, outputExtendSize);
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                System.out.println(this.toString() + " exception creating connection: " + String.valueOf(e));
            }
        }
        return connection;
    }

    @Override
    public String toString() {
        return "[BlockingReconnector, servers=" + String.valueOf(this.servers) + "]";
    }
}

