/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.client;

import com.swiftmq.net.client.Connection;
import com.swiftmq.net.client.ExceptionHandler;
import com.swiftmq.net.client.InboundHandler;
import com.swiftmq.net.protocol.ChunkListener;
import com.swiftmq.swiftlet.net.IntraVMServerEndpoint;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class IntraVMConnection
implements Connection,
ChunkListener {
    static AtomicInteger connectionId = new AtomicInteger(0);
    IntraVMServerEndpoint endpoint = null;
    InboundHandler inboundHandler = null;
    ExceptionHandler exceptionHandler = null;
    DataByteArrayInputStream dis = new DataByteArrayInputStream();
    OutputStream out = new DataByteArrayOutputStream(){

        @Override
        public void flush() throws IOException {
            if (IntraVMConnection.this.closed || IntraVMConnection.this.endpoint.isClosed()) {
                throw new IOException("Connection is closed");
            }
            super.flush();
            IntraVMConnection.this.endpoint.chunkCompleted(this.getBuffer(), 0, this.getCount());
            this.rewind();
        }
    };
    String myHostname = "INTRAVM-" + IntraVMConnection.getConnectionId();
    boolean closed = false;
    AtomicBoolean inputActiveIndicator = null;

    private static int getConnectionId() {
        return connectionId.getAndIncrement();
    }

    public void setEndpoint(IntraVMServerEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setInputActiveIndicator(AtomicBoolean inputActiveIndicator) {
        this.inputActiveIndicator = inputActiveIndicator;
    }

    @Override
    public void chunkCompleted(byte[] b, int offset, int len) {
        this.dis.setBuffer(b, offset, len);
        this.inboundHandler.dataAvailable(this.dis);
    }

    @Override
    public void setInboundHandler(InboundHandler inboundHandler) {
        this.inboundHandler = inboundHandler;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public String getLocalHostname() {
        return this.myHostname;
    }

    @Override
    public String getHostname() {
        return "INTRAVM";
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public void start() {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void serverClose() {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.onException(new IOException("Server closed connection!"));
        }
        this.closed = true;
    }

    @Override
    public void close() {
        this.endpoint.clientClose();
        this.closed = true;
    }
}

