/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.client;

import com.swiftmq.net.client.Connection;
import com.swiftmq.net.client.ServerEntry;
import com.swiftmq.tools.concurrent.Semaphore;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class Reconnector {
    List servers = null;
    Map parameters = null;
    boolean enabled = false;
    int maxRetries = 0;
    long retryDelay = 0L;
    boolean debug = false;
    Connection active = null;
    int currentPos = 0;
    boolean closed = false;
    boolean firstConnectAttempt = true;
    String debugString = null;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    Semaphore waitSem = new Semaphore();

    protected Reconnector(List servers, Map parameters, boolean enabled, int maxRetries, long retryDelay, boolean debug) {
        this.servers = servers;
        this.parameters = parameters;
        this.enabled = enabled;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.debug = debug;
        if (debug) {
            System.out.println(this.dbg() + " created, enabled=" + enabled + ", maxRetries=" + maxRetries + ", retryDelay=" + retryDelay + ", servers=" + String.valueOf(servers) + ", parameters=" + String.valueOf(parameters));
        }
    }

    private String dbg() {
        return String.valueOf(new Date()) + " " + (this.debugString == null ? this.toString() : this.debugString);
    }

    public void setDebugString(String debugString) {
        this.debugString = "[Reconnector, " + debugString + "]";
    }

    public List getServers() {
        return this.servers;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isIntraVM() {
        return false;
    }

    protected abstract Connection createConnection(ServerEntry var1, Map var2);

    public Connection getConnection() {
        this.lock.writeLock().lock();
        try {
            if (this.debug) {
                System.out.println(this.dbg() + ", getConnection ...");
            }
            int nRetries = -1;
            while (!this.closed && this.active == null && nRetries < this.maxRetries) {
                if (this.retryDelay > 0L && !this.firstConnectAttempt) {
                    if (this.debug) {
                        System.out.println(this.dbg() + ", nRetries=" + nRetries + ", waiting " + this.retryDelay + " ms ...");
                    }
                    this.waitSem.waitHere(this.retryDelay);
                    this.waitSem.reset();
                }
                if (this.currentPos == this.servers.size()) {
                    this.currentPos = 0;
                }
                ServerEntry entry = (ServerEntry)this.servers.get(this.currentPos++);
                if (this.debug) {
                    System.out.println(this.dbg() + ", nRetries=" + nRetries + ", attempt to create connection to: " + String.valueOf(entry));
                }
                this.active = this.createConnection(entry, this.parameters);
                if (this.debug) {
                    System.out.println(this.dbg() + ", nRetries=" + nRetries + ", createConnection returns " + String.valueOf(this.active));
                }
                if (this.active == null) {
                    if (!this.enabled) break;
                    ++nRetries;
                }
                this.firstConnectAttempt = false;
            }
            if (this.debug) {
                System.out.println(this.dbg() + ", getConnection returns " + String.valueOf(this.active));
            }
            Connection connection = this.active;
            return connection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void invalidateConnection() {
        this.lock.writeLock().lock();
        try {
            if (this.debug) {
                System.out.println(this.dbg() + ", invalidateConnection, active=" + String.valueOf(this.active));
            }
            if (this.active != null) {
                this.active.close();
                this.active = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void close() {
        this.lock.writeLock().lock();
        try {
            if (this.debug) {
                System.out.println(this.dbg() + ", close, active=" + String.valueOf(this.active));
            }
            this.closed = true;
            if (this.active != null) {
                this.active.close();
                this.active = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.waitSem.notifySingleWaiter();
    }

    public String toString() {
        return "Reconnector";
    }
}

