/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol;

import com.swiftmq.net.protocol.OutputListener;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ProtocolOutputHandler
extends OutputStream {
    OutputListener listener = null;

    public final void setOutputListener(OutputListener listener) {
        this.listener = listener;
    }

    public final void invokeOutputListener() throws IOException {
        while (this.getChunkCount() > 0) {
            this.setBytesWritten(this.listener.performWrite(this.getByteArray(), this.getOffset(), this.getLength()));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.addByte((byte)b);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.addBytes(b, offset, len);
    }

    @Override
    public void flush() throws IOException {
        this.markChunkCompleted();
    }

    public abstract ProtocolOutputHandler create(int var1, int var2);

    public abstract int getChunkCount();

    protected abstract void markChunkCompleted();

    protected abstract byte[] getByteArray();

    protected abstract int getOffset();

    protected abstract int getLength();

    protected abstract void setBytesWritten(int var1);

    protected abstract void addByte(byte var1);

    protected abstract void addBytes(byte[] var1, int var2, int var3);
}

