/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.amqp;

import com.swiftmq.net.protocol.ChunkListener;
import com.swiftmq.net.protocol.ProtocolInputHandler;
import com.swiftmq.swiftlet.trace.TraceSpace;
import java.nio.ByteBuffer;

public class AMQPInputHandler
implements ProtocolInputHandler {
    ChunkListener listener = null;
    int initialSize = 0;
    int ensureSize = 0;
    byte[] buffer = null;
    ByteBuffer byteBuffer = null;
    int writePos = 0;
    int readPos = 0;
    int length = -1;
    boolean mode091 = false;
    volatile int minLength = 4;
    volatile boolean protHeaderExpected = true;
    volatile String tracePrefix = null;
    volatile String traceKey = null;
    volatile TraceSpace traceSpace = null;

    @Override
    public ProtocolInputHandler create() {
        AMQPInputHandler handler = new AMQPInputHandler();
        handler.setTraceKey(this.traceKey);
        handler.setTracePrefix(this.tracePrefix);
        handler.setTraceSpace(this.traceSpace);
        return handler;
    }

    private int readInt(byte[] b, int offset) {
        int pos = offset;
        int i1 = b[pos++] & 0xFF;
        int i2 = b[pos++] & 0xFF;
        int i3 = b[pos++] & 0xFF;
        int i4 = b[pos++] & 0xFF;
        int i = (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
        return i;
    }

    public void setTraceSpace(TraceSpace traceSpace) {
        this.traceSpace = traceSpace;
    }

    public void setTraceKey(String traceKey) {
        this.traceKey = traceKey;
    }

    public void setTracePrefix(String tracePrefix) {
        this.tracePrefix = tracePrefix;
    }

    public void setProtHeaderExpected(boolean protHeaderExpected) {
        this.protHeaderExpected = protHeaderExpected;
    }

    public void setMode091(boolean mode091) {
        this.mode091 = mode091;
        if (mode091) {
            this.minLength = 7;
        }
    }

    @Override
    public void setChunkListener(ChunkListener listener) {
        this.listener = listener;
    }

    @Override
    public void createInputBuffer(int initialSize, int ensureSize) {
        this.initialSize = initialSize;
        this.ensureSize = ensureSize;
        this.buffer = new byte[initialSize];
        this.byteBuffer = ByteBuffer.wrap(this.buffer);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.getBuffer();
        this.byteBuffer.position(this.writePos);
        return this.byteBuffer;
    }

    @Override
    public byte[] getBuffer() {
        if (this.buffer.length - this.writePos < this.ensureSize) {
            byte[] b = null;
            int available = this.readPos + this.buffer.length - this.writePos;
            b = available >= this.ensureSize ? new byte[this.buffer.length] : new byte[this.buffer.length + this.ensureSize];
            System.arraycopy(this.buffer, this.readPos, b, 0, this.writePos - this.readPos);
            this.buffer = b;
            this.writePos -= this.readPos;
            this.readPos = 0;
            this.byteBuffer = ByteBuffer.wrap(this.buffer);
        }
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.writePos;
    }

    @Override
    public void setBytesWritten(int written) {
        if (written == 0) {
            return;
        }
        this.writePos += written;
        int available = this.writePos - this.readPos;
        boolean moreDataBuffered = false;
        if (this.traceSpace != null && this.traceSpace.enabled) {
            this.traceSpace.trace(this.traceKey, this.tracePrefix + "/" + this.toString() + "/1, setBytesWritten, written=" + written + ", writePos=" + this.writePos + ", readPos=" + this.readPos + ", available=" + available + ", moreDataBuffered=" + moreDataBuffered + ", protHeaderExpected=" + this.protHeaderExpected);
        }
        do {
            moreDataBuffered = false;
            if (this.protHeaderExpected) {
                if (available >= 8) {
                    this.listener.chunkCompleted(this.buffer, this.readPos, 8);
                    this.readPos += 8;
                    boolean bl = moreDataBuffered = (available -= 8) > 0;
                    if (this.traceSpace != null && this.traceSpace.enabled) {
                        this.traceSpace.trace(this.traceKey, this.tracePrefix + "/" + this.toString() + "/2, setBytesWritten, written=" + written + ", writePos=" + this.writePos + ", readPos=" + this.readPos + ", available=" + available + ", moreDataBuffered=" + moreDataBuffered + ", protHeaderExpected=" + this.protHeaderExpected);
                    }
                }
            } else if (this.length == -1) {
                if (available >= this.minLength) {
                    int n = this.length = this.mode091 ? this.readInt(this.buffer, this.readPos + 3) + 8 : this.readInt(this.buffer, this.readPos);
                    if (available >= this.length) {
                        this.listener.chunkCompleted(this.buffer, this.readPos, this.length);
                        this.readPos += this.length;
                        this.length = -1;
                        boolean bl = moreDataBuffered = (available -= this.length) > 0;
                        if (this.traceSpace != null && this.traceSpace.enabled) {
                            this.traceSpace.trace(this.traceKey, this.tracePrefix + "/" + this.toString() + "/3, setBytesWritten, written=" + written + ", writePos=" + this.writePos + ", readPos=" + this.readPos + ", available=" + available + ", moreDataBuffered=" + moreDataBuffered + ", protHeaderExpected=" + this.protHeaderExpected);
                        }
                    }
                }
            } else if (available >= this.length) {
                this.listener.chunkCompleted(this.buffer, this.readPos, this.length);
                this.readPos += this.length;
                this.length = -1;
                boolean bl = moreDataBuffered = (available -= this.length) > 0;
                if (this.traceSpace != null && this.traceSpace.enabled) {
                    this.traceSpace.trace(this.traceKey, this.tracePrefix + "/" + this.toString() + "/4, setBytesWritten, written=" + written + ", writePos=" + this.writePos + ", readPos=" + this.readPos + ", available=" + available + ", moreDataBuffered=" + moreDataBuffered + ", protHeaderExpected=" + this.protHeaderExpected);
                }
            }
            if (this.traceSpace != null && this.traceSpace.enabled) {
                this.traceSpace.trace(this.traceKey, this.tracePrefix + "/" + this.toString() + "/5, setBytesWritten, written=" + written + ", writePos=" + this.writePos + ", readPos=" + this.readPos + ", available=" + available + ", moreDataBuffered=" + moreDataBuffered + ", protHeaderExpected=" + this.protHeaderExpected);
            }
            if (this.readPos != this.writePos) continue;
            this.readPos = 0;
            this.writePos = 0;
            moreDataBuffered = false;
        } while (moreDataBuffered);
        if (this.traceSpace != null && this.traceSpace.enabled) {
            this.traceSpace.trace(this.traceKey, this.tracePrefix + "/" + this.toString() + "/6, setBytesWritten, written=" + written + ", writePos=" + this.writePos + ", readPos=" + this.readPos + ", available=" + available + ", moreDataBuffered=" + moreDataBuffered + ", protHeaderExpected=" + this.protHeaderExpected);
        }
    }

    public String toString() {
        return "AMQPInputHandler, mode091=" + this.mode091;
    }
}

