/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.raw;

import com.swiftmq.net.protocol.ChunkListener;
import com.swiftmq.net.protocol.ProtocolInputHandler;
import java.nio.ByteBuffer;

public class RawInputHandler
implements ProtocolInputHandler {
    ChunkListener listener = null;
    int initialSize = 0;
    byte[] buffer = null;
    ByteBuffer byteBuffer = null;

    @Override
    public ProtocolInputHandler create() {
        return new RawInputHandler();
    }

    @Override
    public void setChunkListener(ChunkListener listener) {
        this.listener = listener;
    }

    @Override
    public void createInputBuffer(int initialSize, int ensureSize) {
        this.initialSize = initialSize;
        this.buffer = new byte[initialSize];
        this.byteBuffer = ByteBuffer.wrap(this.buffer);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.byteBuffer.rewind();
        return this.byteBuffer;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public void setBytesWritten(int written) {
        this.listener.chunkCompleted(this.buffer, 0, written);
    }

    public String toString() {
        return "[RawInputHandler]";
    }
}

