/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.smqp;

import com.swiftmq.net.protocol.ChunkListener;
import com.swiftmq.net.protocol.ProtocolInputHandler;
import java.nio.ByteBuffer;

public class SMQPInputHandler
implements ProtocolInputHandler {
    ChunkListener listener = null;
    byte[] lengthField = new byte[4];
    byte[] buffer = null;
    byte[] prevBuffer = null;
    ByteBuffer byteBuffer = null;
    int bufferOffset = 0;
    boolean lengthComplete = false;
    int lengthByteCount = 0;
    int chunkLength = 0;

    @Override
    public ProtocolInputHandler create() {
        return new SMQPInputHandler();
    }

    @Override
    public void setChunkListener(ChunkListener listener) {
        this.listener = listener;
    }

    @Override
    public void createInputBuffer(int initialSize, int ensureSize) {
        this.buffer = this.lengthField;
        this.byteBuffer = ByteBuffer.wrap(this.buffer);
        this.bufferOffset = 0;
        this.lengthByteCount = 0;
        this.lengthComplete = false;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.byteBuffer.position(this.bufferOffset);
        return this.byteBuffer;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.bufferOffset;
    }

    private int readLength(byte[] b, int offset) {
        int i1 = b[offset] & 0xFF;
        int i2 = b[offset + 1] & 0xFF;
        int i3 = b[offset + 2] & 0xFF;
        int i4 = b[offset + 3] & 0xFF;
        int i = (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
        return i;
    }

    @Override
    public void setBytesWritten(int written) {
        if (this.lengthComplete) {
            this.bufferOffset += written;
            if (this.bufferOffset == this.chunkLength) {
                this.listener.chunkCompleted(this.buffer, 0, this.chunkLength);
                this.lengthComplete = false;
                this.lengthByteCount = 0;
                this.bufferOffset = 0;
                this.prevBuffer = this.buffer;
                this.buffer = this.lengthField;
                this.byteBuffer = ByteBuffer.wrap(this.buffer);
            }
        } else {
            this.lengthByteCount += written;
            this.bufferOffset += written;
            if (this.lengthByteCount == 4) {
                this.chunkLength = this.readLength(this.buffer, 0);
                this.buffer = this.prevBuffer != null && this.prevBuffer.length == this.chunkLength ? this.prevBuffer : new byte[this.chunkLength];
                this.byteBuffer = ByteBuffer.wrap(this.buffer);
                this.lengthComplete = true;
                this.bufferOffset = 0;
                this.lengthByteCount = 0;
            }
        }
    }

    public String toString() {
        return "[SMQPInputHandler]";
    }
}

