/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.smqp;

import com.swiftmq.net.protocol.ProtocolOutputHandler;
import com.swiftmq.net.protocol.util.FragmentedOutputStream;

public class SMQPOutputHandler
extends ProtocolOutputHandler {
    private final FragmentedOutputStream fragmentedOutputStream;
    private FragmentedOutputStream.Fragment currentFragment = null;
    private int currentOffset = 0;
    private int chunkCount = 0;
    private int currentFragmentIndex = 0;

    public SMQPOutputHandler(int bufferSize, int extendSize) {
        this.fragmentedOutputStream = new FragmentedOutputStream(bufferSize, true);
    }

    @Override
    public ProtocolOutputHandler create(int bufferSize, int extendSize) {
        return new SMQPOutputHandler(bufferSize, extendSize);
    }

    @Override
    public int getChunkCount() {
        return this.chunkCount;
    }

    @Override
    protected byte[] getByteArray() {
        return this.currentFragment != null ? this.currentFragment.getData() : null;
    }

    @Override
    protected int getOffset() {
        return this.currentOffset;
    }

    @Override
    protected int getLength() {
        int length = this.currentFragment != null ? this.currentFragment.getLength() - this.currentOffset : 0;
        return length;
    }

    @Override
    protected void setBytesWritten(int written) {
        if (this.currentFragment != null) {
            this.currentOffset += written;
            if (this.currentOffset >= this.currentFragment.getLength()) {
                this.currentOffset = 0;
                ++this.currentFragmentIndex;
                if (this.currentFragmentIndex >= this.fragmentedOutputStream.getFragmentCount()) {
                    this.resetFragmentedOutputStream();
                } else {
                    this.currentFragment = this.fragmentedOutputStream.getFragment(this.currentFragmentIndex);
                    --this.chunkCount;
                }
            }
        }
    }

    private void resetFragmentedOutputStream() {
        this.fragmentedOutputStream.reset();
        this.currentFragment = null;
        this.currentFragmentIndex = 0;
        this.currentOffset = 0;
        this.chunkCount = 0;
    }

    @Override
    protected void addByte(byte b) {
        this.fragmentedOutputStream.write(b);
    }

    @Override
    protected void addBytes(byte[] b, int offset, int len) {
        this.fragmentedOutputStream.write(b, offset, len);
    }

    @Override
    protected void markChunkCompleted() {
        this.fragmentedOutputStream.finish();
        this.currentFragment = this.fragmentedOutputStream.getFragment(0);
        this.currentOffset = 0;
        this.chunkCount = this.fragmentedOutputStream.getFragmentCount();
    }

    public String toString() {
        return "[SMQPOutputHandler, chunkCount=" + this.getChunkCount() + "]";
    }
}

