/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.util;

import com.swiftmq.tools.gc.WeakPool;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class FragmentedOutputStream {
    private final List<Fragment> fragments = new ArrayList<Fragment>();
    private final WeakPool<Fragment> fragmentPool = new WeakPool();
    private final int fragmentSize;
    private boolean includeLength;
    private int totalLength = 0;

    public FragmentedOutputStream(int fragmentSize, boolean includeLength) {
        if (fragmentSize <= 0) {
            throw new IllegalArgumentException("Fragment size must be greater than 0");
        }
        this.fragmentSize = fragmentSize;
        this.includeLength = includeLength;
        this.firstFragment();
        this.totalLength = 0;
    }

    private void firstFragment() {
        Fragment fragment = this.fragmentPool.get(() -> new Fragment(new byte[this.fragmentSize], 0));
        fragment.length = this.includeLength ? 4 : 0;
        this.fragments.add(fragment);
    }

    private void ensureCapacity(int length) {
        if (this.fragments.isEmpty() || this.fragments.get(this.fragments.size() - 1).isFull()) {
            this.fragments.add(this.fragmentPool.get(() -> new Fragment(new byte[this.fragmentSize], 0)));
        }
    }

    public Fragment getCurrentFragment() {
        return this.fragments.get(this.fragments.size() - 1);
    }

    public void write(int b) {
        this.ensureCapacity(1);
        Fragment currentFragment = this.getCurrentFragment();
        currentFragment.data[currentFragment.length++] = (byte)b;
        if (this.includeLength) {
            ++this.totalLength;
        }
    }

    public void write(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int bytesWritten = 0;
        while (bytesWritten < len) {
            this.ensureCapacity(len - bytesWritten);
            Fragment currentFragment = this.getCurrentFragment();
            int bytesToWrite = Math.min(len - bytesWritten, this.fragmentSize - currentFragment.length);
            System.arraycopy(b, off + bytesWritten, currentFragment.data, currentFragment.length, bytesToWrite);
            bytesWritten += bytesToWrite;
            currentFragment.length += bytesToWrite;
            if (!this.includeLength) continue;
            this.totalLength += bytesToWrite;
        }
    }

    public void finish() {
        if (this.includeLength) {
            ByteBuffer.wrap(this.fragments.get((int)0).data).putInt(0, this.totalLength);
        }
    }

    public void reset() {
        this.fragments.forEach(f -> {
            f.length = 0;
            this.fragmentPool.checkIn((Fragment)f);
        });
        this.fragments.clear();
        this.firstFragment();
        this.totalLength = 0;
    }

    public int getFragmentCount() {
        return this.fragments.size();
    }

    public Fragment getFragment(int index) {
        if (index < 0 || index >= this.getFragmentCount()) {
            throw new IndexOutOfBoundsException("Fragment index out of range: " + index);
        }
        return this.fragments.get(index);
    }

    public class Fragment {
        byte[] data;
        int length;

        public Fragment(byte[] data, int length) {
            this.data = data;
            this.length = length;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isFull() {
            return this.length == this.data.length;
        }
    }
}

