/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet;

import com.swiftmq.mgmt.Configuration;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.Property;
import com.swiftmq.mgmt.PropertyChangeException;
import com.swiftmq.mgmt.RouterConfiguration;
import com.swiftmq.mgmt.XMLUtilities;
import com.swiftmq.swiftlet.Swiftlet;
import com.swiftmq.swiftlet.SwiftletManager;
import com.swiftmq.swiftlet.log.LogSwiftlet;
import com.swiftmq.swiftlet.timer.event.TimerListener;
import com.swiftmq.swiftlet.trace.TraceSpace;
import com.swiftmq.tools.sql.LikeComparator;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;

public class ConfigfileWatchdog
implements TimerListener {
    static List<String> EXCLUDES = new ArrayList<String>();
    static List<String> DELEXCLUDES = new ArrayList<String>();
    TraceSpace traceSpace = null;
    LogSwiftlet logSwiftlet = null;
    String filename = null;
    long lastModified;

    public ConfigfileWatchdog(TraceSpace traceSpace, LogSwiftlet logSwiftlet, String filename) {
        this.traceSpace = traceSpace;
        this.logSwiftlet = logSwiftlet;
        this.filename = filename;
        this.lastModified = new File(filename).lastModified();
        if (traceSpace.enabled) {
            traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/started");
        }
    }

    private boolean isExcluded(String context) {
        for (int i = 0; i < EXCLUDES.size(); ++i) {
            if (!LikeComparator.compare(context, EXCLUDES.get(i), '\\')) continue;
            return true;
        }
        return false;
    }

    private boolean isDelExcluded(String context) {
        for (int i = 0; i < DELEXCLUDES.size(); ++i) {
            if (!LikeComparator.compare(context, DELEXCLUDES.get(i), '\\')) continue;
            return true;
        }
        return false;
    }

    private void applyNewEntities(String context, Entity oldConfig, Entity newConfig) throws Exception {
        Map entities;
        if (this.isExcluded(context)) {
            return;
        }
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyNewEntities, context=" + context);
        }
        if ((entities = newConfig.getEntities()) == null || entities.size() == 0) {
            return;
        }
        for (Map.Entry entry : entities.entrySet()) {
            String name = (String)entry.getKey();
            Entity entity = (Entity)entry.getValue();
            if (oldConfig.getEntity(name) == null) {
                if (this.traceSpace.enabled) {
                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyNewEntities, context=" + context + ", entity added=" + entity.getName());
                }
                this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyNewEntities, context=" + context + ", entity added=" + entity.getName());
                oldConfig.addEntity(entity);
                continue;
            }
            this.applyNewEntities(context + "/" + entity.getName(), oldConfig.getEntity(name), entity);
        }
    }

    private void applyDeletedEntities(String context, Entity oldConfig, Entity newConfig) throws Exception {
        Map entities;
        if (this.isExcluded(context) || this.isDelExcluded(context)) {
            return;
        }
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyDeletedEntities, context=" + context);
        }
        if ((entities = oldConfig.getEntities()) == null || entities.size() == 0) {
            return;
        }
        for (Map.Entry entry : entities.entrySet()) {
            String name = (String)entry.getKey();
            Entity entity = (Entity)entry.getValue();
            if (newConfig.getEntity(name) == null && !this.isDelExcluded(context + "/" + name)) {
                if (this.traceSpace.enabled) {
                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyDeletedEntities, context=" + context + ", entity deleted=" + entity.getName());
                }
                this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyDeletedEntities, context=" + context + ", entity deleted=" + entity.getName());
                oldConfig.removeEntity(entity);
                continue;
            }
            this.applyDeletedEntities(context + "/" + entity.getName(), entity, newConfig.getEntity(name));
        }
    }

    private void applyEntityPropChanges(String context, Entity oldConfig, String name, Entity oldEntity, Entity newEntity) throws Exception {
        if (this.isExcluded(context + "/" + name)) {
            return;
        }
        Map props = oldEntity.getProperties();
        if (props != null && props.size() > 0) {
            Iterator propIter = props.entrySet().iterator();
            while (propIter.hasNext()) {
                Property oldProp = (Property)propIter.next().getValue();
                Property newProp = newEntity.getProperty(oldProp.getName());
                if (this.traceSpace.enabled) {
                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName());
                }
                if (oldProp.getValue() == null && newProp.getValue() == null || oldProp.getValue().equals(newProp.getValue())) continue;
                if (oldProp.isReadOnly()) {
                    if (oldConfig == null) continue;
                    if (this.traceSpace.enabled) {
                        this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", new value=" + String.valueOf(newProp.getValue()));
                    }
                    this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", new value=" + String.valueOf(newProp.getValue()));
                    if (this.traceSpace.enabled) {
                        this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", property is read-only, recreate entity");
                    }
                    this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", property is read-only, recreate entity");
                    oldConfig.removeEntity(oldEntity);
                    oldProp.setReadOnly(false);
                    oldProp.setValue(newProp.getValue());
                    oldProp.setReadOnly(true);
                    oldConfig.addEntity(oldEntity);
                } else {
                    try {
                        if (this.traceSpace.enabled) {
                            this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", new value=" + String.valueOf(newProp.getValue()));
                        }
                        this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", new value=" + String.valueOf(newProp.getValue()));
                        oldProp.setValue(newProp.getValue());
                    }
                    catch (PropertyChangeException e) {
                        Property enabledProp = oldEntity.getProperty("enabled");
                        if (enabledProp != null && ((Boolean)enabledProp.getValue()).booleanValue()) {
                            try {
                                if (this.traceSpace.enabled) {
                                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", try setting 'enabled' property to false and set the value...");
                                }
                                enabledProp.setValue(false);
                                oldProp.setValue(newProp.getValue());
                                enabledProp.setValue(true);
                                if (this.traceSpace.enabled) {
                                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", worked!");
                                }
                            }
                            catch (PropertyChangeException e1) {
                                if (this.traceSpace.enabled) {
                                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got PropertyChangeException: " + e1.getMessage());
                                }
                                this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got PropertyChangeException: " + e1.getMessage());
                            }
                            catch (Exception e1) {
                                if (this.traceSpace.enabled) {
                                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got exception: " + e1.getMessage());
                                }
                                this.logSwiftlet.logError("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got exception: " + e1.getMessage());
                            }
                        }
                        if (this.traceSpace.enabled) {
                            this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got PropertyChangeException: " + e.getMessage());
                        }
                        this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got PropertyChangeException: " + e.getMessage());
                    }
                    catch (Exception e) {
                        if (this.traceSpace.enabled) {
                            this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got exception: " + e.getMessage());
                        }
                        this.logSwiftlet.logError("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", got exception: " + e.getMessage());
                    }
                }
                if (!oldProp.isRebootRequired()) continue;
                if (this.traceSpace.enabled) {
                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", property change requires a reboot!");
                }
                this.logSwiftlet.logInformation("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", property change requires a reboot!");
                this.logSwiftlet.logWarning("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context + ", entity=" + name + ", property=" + oldProp.getName() + ", property change requires a reboot!");
            }
        }
    }

    private void applyPropertyChanges(String context, Entity oldConfig, Entity newConfig) throws Exception {
        if (this.isExcluded(context)) {
            return;
        }
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/applyPropertyChanges, context=" + context);
        }
        this.applyEntityPropChanges(context, null, oldConfig.getName(), oldConfig, newConfig);
        Map entities = oldConfig.getEntities();
        if (entities == null || entities.size() == 0) {
            return;
        }
        for (Map.Entry entry : entities.entrySet()) {
            String name = (String)entry.getKey();
            Entity oldEntity = (Entity)entry.getValue();
            Entity newEntity = newConfig.getEntity(name);
            if (newEntity == null) break;
            this.applyEntityPropChanges(context, oldConfig, name, oldEntity, newEntity);
            this.applyPropertyChanges(context + "/" + name, oldEntity, newEntity);
        }
    }

    @Override
    public void performTimeAction() {
        File f = new File(this.filename);
        long newLastModified = f.lastModified();
        if (newLastModified == this.lastModified) {
            if (this.traceSpace.enabled) {
                this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/no change detected");
            }
            return;
        }
        try {
            if (this.traceSpace.enabled) {
                this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/change detected");
            }
            Document newConfigfile = XMLUtilities.createDocument(new FileInputStream(f));
            Map configurations = RouterConfiguration.Singleton().getConfigurations();
            for (Map.Entry entry : configurations.entrySet()) {
                Swiftlet swiftlet;
                String swiftletName = (String)entry.getKey();
                if (swiftletName.equals(".env")) continue;
                if (this.traceSpace.enabled) {
                    this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction/checking swiftlet=" + swiftletName);
                }
                if ((swiftlet = SwiftletManager.getInstance()._getSwiftlet(swiftletName)) == null || swiftlet.getState() != 0) continue;
                Configuration config = (Configuration)entry.getValue();
                Configuration newConfig = SwiftletManager.getInstance().fillConfigurationFromTemplate(swiftletName, newConfigfile);
                if (newConfig == null) continue;
                this.applyNewEntities("/" + swiftletName, config, newConfig);
                this.applyDeletedEntities("/" + swiftletName, config, newConfig);
                this.applyPropertyChanges("/" + swiftletName, config, newConfig);
            }
            this.lastModified = newLastModified;
        }
        catch (Exception e) {
            if (this.traceSpace.enabled) {
                this.traceSpace.trace("SwiftletManager", "ConfigfileWatchdog/performTimeAction, got exception: " + e.getMessage());
            }
            this.logSwiftlet.logError("SwiftletManager", "ConfigfileWatchdog/performTimeAction, got exception: " + e.getMessage());
        }
    }

    static {
        EXCLUDES.add("/%/.metadata");
        EXCLUDES.add("/%/usage");
        DELEXCLUDES.add("/sys$amqp/declarations/transformer/default-inbound-transformers/0");
        DELEXCLUDES.add("/sys$amqp/declarations/transformer/default-outbound-transformers/0");
    }
}

