/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.Configuration;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.PreConfigurator;
import com.swiftmq.mgmt.Property;
import com.swiftmq.mgmt.PropertyChangeAdapter;
import com.swiftmq.mgmt.PropertyChangeException;
import com.swiftmq.mgmt.RouterConfigInstance;
import com.swiftmq.mgmt.RouterConfiguration;
import com.swiftmq.mgmt.XMLUtilities;
import com.swiftmq.swiftlet.ConfigfileWatchdog;
import com.swiftmq.swiftlet.RouterMemoryMeter;
import com.swiftmq.swiftlet.Swiftlet;
import com.swiftmq.swiftlet.SwiftletDeployer;
import com.swiftmq.swiftlet.SwiftletException;
import com.swiftmq.swiftlet.UnknownSwiftletException;
import com.swiftmq.swiftlet.event.KernelStartupListener;
import com.swiftmq.swiftlet.event.SwiftletManagerEvent;
import com.swiftmq.swiftlet.event.SwiftletManagerListener;
import com.swiftmq.swiftlet.log.LogSwiftlet;
import com.swiftmq.swiftlet.timer.TimerSwiftlet;
import com.swiftmq.swiftlet.trace.TraceSpace;
import com.swiftmq.swiftlet.trace.TraceSwiftlet;
import com.swiftmq.tools.deploy.Bundle;
import com.swiftmq.tools.deploy.BundleEvent;
import com.swiftmq.tools.deploy.DeployPath;
import com.swiftmq.tools.file.NumberBackupFileReducer;
import com.swiftmq.tools.log.NullPrintStream;
import com.swiftmq.upgrade.UpgradeUtilities;
import com.swiftmq.util.SwiftUtilities;
import com.swiftmq.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SwiftletManager {
    static final String PROP_INITIAL_CONFIG = "swiftmq.initialconfig";
    static final String PROP_PRECONFIG = "swiftmq.preconfig";
    static final String PROP_SHUTDOWN_HOOK = "swiftmq.shutdown.hook";
    static final String PROP_REUSE_KERNEL_CL = "swiftmq.reuse.kernel.classloader";
    static final long PROP_CONFIG_WATCHDOG_INTERVAL = Long.parseLong(System.getProperty("swiftmq.config.watchdog.interval", "0"));
    protected static final AtomicReference<SwiftletManager> _instance = new AtomicReference();
    static SimpleDateFormat fmt = new SimpleDateFormat(".yyyyMMddHHmmssSSS");
    final AtomicReference<String> configFilename = new AtomicReference();
    final AtomicReference<Document> routerConfig = new AtomicReference();
    final AtomicReference<String> routerName = new AtomicReference();
    final AtomicReference<String> workingDirectory = new AtomicReference<String>(System.getProperty("user.dir"));
    String[] kernelSwiftletNames = null;
    Map<String, Swiftlet> swiftletTable = null;
    DeployPath dp = null;
    Map<String, Bundle> bundleTable = null;
    Map<String, HashSet<SwiftletManagerListener>> listeners = new ConcurrentHashMap<String, HashSet<SwiftletManagerListener>>();
    Set allListeners = ConcurrentHashMap.newKeySet();
    Set<KernelStartupListener> kernelListeners = new HashSet<KernelStartupListener>();
    Map<String, Object> surviveMap = new ConcurrentHashMap<String, Object>();
    RouterMemoryMeter memoryMeter = null;
    SwiftletDeployer swiftletDeployer = null;
    LogSwiftlet logSwiftlet = null;
    TraceSwiftlet traceSwiftlet = null;
    TimerSwiftlet timerSwiftlet = null;
    ConfigfileWatchdog configfileWatchdog = null;
    TraceSpace traceSpace = null;
    final AtomicLong memCollectInterval = new AtomicLong(10000L);
    final AtomicBoolean smartTree = new AtomicBoolean(true);
    final AtomicBoolean startup = new AtomicBoolean(false);
    final AtomicBoolean rebooting = new AtomicBoolean(false);
    final AtomicBoolean workingDirAdded = new AtomicBoolean(false);
    final AtomicBoolean registerShutdownHook = new AtomicBoolean(Boolean.parseBoolean(System.getProperty("swiftmq.shutdown.hook", "true")));
    final AtomicBoolean quietMode = new AtomicBoolean(false);
    final AtomicBoolean strippedMode = new AtomicBoolean(false);
    final AtomicBoolean doFireKernelStartedEvent = new AtomicBoolean(true);
    final AtomicBoolean configDirty = new AtomicBoolean(false);
    PrintStream savedSystemOut = System.out;
    volatile Thread shutdownHook = null;
    volatile Thread keepAliveThread = null;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected SwiftletManager() {
    }

    public static SwiftletManager getInstance() {
        if (_instance.get() == null) {
            _instance.compareAndSet(null, new SwiftletManager());
        }
        return _instance.get();
    }

    private void initializeKeepAliveThread() {
        if (this.keepAliveThread == null) {
            this.keepAliveThread = new Thread(() -> {
                this.logSwiftlet.logInformation("SwiftletManager", "Keep-alive thread running.");
                LockSupport.park();
                this.logSwiftlet.logInformation("SwiftletManager", "Keep-alive thread terminating.");
            });
            this.keepAliveThread.setDaemon(false);
            this.keepAliveThread.start();
        }
    }

    public boolean isHA() {
        return false;
    }

    public void setDoFireKernelStartedEvent(boolean doFireKernelStartedEvent) {
        this.doFireKernelStartedEvent.set(doFireKernelStartedEvent);
    }

    protected void trace(String message) {
        if (!this.quietMode.get() && this.traceSpace != null && this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", message);
        }
    }

    protected void startSwiftletDeployer() {
        this.swiftletDeployer = new SwiftletDeployer();
        this.swiftletDeployer.start();
    }

    protected void stopSwiftletDeployer() {
        if (this.swiftletDeployer != null) {
            this.swiftletDeployer.stop();
        }
    }

    protected Configuration getConfiguration(Swiftlet swiftlet) throws Exception {
        this.trace("Swiftlet " + swiftlet.getName() + "', getConfiguration");
        Configuration config = (Configuration)RouterConfiguration.Singleton().getConfigurations().get(swiftlet.getName());
        if (config == null) {
            this.trace("Swiftlet " + swiftlet.getName() + "', get configuration template");
            config = this.getConfigurationTemplate(swiftlet.getName());
            if (config == null) {
                throw new Exception("Swiftlet " + swiftlet.getName() + "', getConfigurationTemplate returns null");
            }
            this.trace("Swiftlet " + swiftlet.getName() + "', fill configuration");
            config.getMetaData().setName(swiftlet.getName());
            config = this.fillConfiguration(config);
        }
        return config;
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)RouterConfiguration.Singleton().getConfigurations().get(name);
    }

    private void startUpSwiftlet(Swiftlet swiftlet, Configuration config) throws SwiftletException {
        System.out.println("... startup: " + config.getMetaData().getDisplayName());
        if (this.logSwiftlet != null) {
            this.logSwiftlet.logInformation("SwiftletManager", "Swiftlet starting: " + swiftlet.getName() + " ...");
        }
        if (swiftlet.isKernel()) {
            this.trace("Swiftlet " + swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStartInitiated");
            this.fireSwiftletManagerEvent(swiftlet.getName(), "swiftletStartInitiated", new SwiftletManagerEvent(this, swiftlet.getName()));
            this.trace("Swiftlet " + swiftlet.getName() + "', swiftlet.startup()");
        }
        swiftlet.startup(config);
        swiftlet.setState(0);
        if (this.logSwiftlet != null) {
            this.logSwiftlet.logInformation("SwiftletManager", "Swiftlet started: " + swiftlet.getName());
        }
        if (swiftlet.isKernel()) {
            this.trace("Swiftlet " + swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStarted");
            this.fireSwiftletManagerEvent(swiftlet.getName(), "swiftletStarted", new SwiftletManagerEvent(this, swiftlet.getName()));
        }
    }

    protected void shutdownSwiftlet(Swiftlet swiftlet) throws SwiftletException {
        try {
            Configuration config = this.getConfiguration(swiftlet);
            System.out.println("... shutdown: " + config.getMetaData().getDisplayName());
        }
        catch (Exception config) {
            // empty catch block
        }
        SwiftletShutdown ss = new SwiftletShutdown(swiftlet);
        Thread t = new Thread(ss);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ss.getException() != null) {
            throw ss.getException();
        }
    }

    protected void startKernelSwiftlets() {
        String actSwiftletName = null;
        TraceSwiftlet swiftlet = null;
        long startupTime = -1L;
        Object className = null;
        try {
            actSwiftletName = "sys$trace";
            swiftlet = null;
            startupTime = -1L;
            try {
                swiftlet = (TraceSwiftlet)this.loadSwiftlet(actSwiftletName);
            }
            catch (Exception e) {
                System.err.println("Exception occurred while creating TraceSwiftlet instance: " + e.getMessage());
                System.exit(-1);
            }
            swiftlet.setName(actSwiftletName);
            swiftlet.setKernel(true);
            Configuration c = this.getConfiguration(swiftlet);
            RouterConfiguration.Singleton().getConfigurations().put(actSwiftletName, c);
            this.startUpSwiftlet(swiftlet, c);
            swiftlet.setStartupTime(System.currentTimeMillis());
            this.swiftletTable.put(actSwiftletName, swiftlet);
            this.traceSwiftlet = swiftlet;
            this.traceSpace = this.traceSwiftlet.getTraceSpace("kernel");
            this.trace("Trace swiftlet '" + actSwiftletName + " has been started");
            this.trace("Starting kernel swiftlets");
            String[] stringArray = this.kernelSwiftletNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String kernelSwiftletName;
                actSwiftletName = kernelSwiftletName = stringArray[i];
                this.startKernelSwiftlet(actSwiftletName, this.swiftletTable);
                if (!kernelSwiftletName.equals("sys$log")) continue;
                this.logSwiftlet = (LogSwiftlet)this.getSwiftlet("sys$log");
            }
            if (!this.isHA()) {
                this.startSwiftletDeployer();
            }
            this.initializeKeepAliveThread();
            this.saveConfigIfDirty();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("Kernel swiftlet: '" + actSwiftletName + "', exception during startup: " + e.getMessage());
            System.err.println("Exception during startup kernel swiftlet '" + actSwiftletName + "': " + e.getMessage());
            System.exit(-1);
        }
        this.trace("Kernel swiftlets started");
    }

    protected void startKernelSwiftlet(String actSwiftletName, Map<String, Swiftlet> table) throws Exception {
        this.trace("Starting kernel swiftlet: '" + actSwiftletName + "' ...");
        Swiftlet swiftlet = null;
        long startupTime = -1L;
        this.trace("Kernel swiftlet: '" + actSwiftletName + "'");
        try {
            swiftlet = this.loadSwiftlet(actSwiftletName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("Kernel swiftlet: '" + actSwiftletName + "', exception occurred while creating Swiftlet instance: " + e.getMessage());
            System.err.println("Exception occurred while creating Swiftlet instance: " + e.getMessage());
            System.exit(-1);
        }
        swiftlet.setName(actSwiftletName);
        swiftlet.setKernel(true);
        this.trace("Kernel swiftlet: '" + actSwiftletName + "', startUpSwiftlet ...");
        table.put(actSwiftletName, swiftlet);
        Configuration conf = this.getConfiguration(swiftlet);
        RouterConfiguration.Singleton().getConfigurations().put(actSwiftletName, conf);
        this.startUpSwiftlet(swiftlet, conf);
        swiftlet.setStartupTime(System.currentTimeMillis());
        this.trace("Kernel swiftlet: '" + actSwiftletName + "', is running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopKernelSwiftlets() {
        this.lock.writeLock().lock();
        try {
            this.trace("stopKernelSwiftlets");
            this.logSwiftlet.logInformation("SwiftletManager", "stopKernelSwiftlets");
            this.stopSwiftletDeployer();
            ArrayList<Swiftlet> al = new ArrayList<Swiftlet>();
            for (int i = this.kernelSwiftletNames.length - 1; i >= 0; --i) {
                String name = this.kernelSwiftletNames[i];
                Swiftlet swiftlet2 = this.swiftletTable.get(name);
                if (swiftlet2.getState() != 0) continue;
                al.add(swiftlet2);
            }
            al.add(this.swiftletTable.get("sys$trace"));
            al.forEach(swiftlet -> {
                try {
                    this.shutdownSwiftlet((Swiftlet)swiftlet);
                }
                catch (SwiftletException swiftletException) {
                    // empty catch block
                }
                swiftlet.setStartupTime(-1L);
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void fillSwiftletTable() {
        for (String kernelSwiftletName : this.kernelSwiftletNames) {
            this.swiftletTable.put(kernelSwiftletName, null);
        }
    }

    public String getWorkingDirectory() {
        return this.workingDirectory.get();
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory.set(workingDirectory);
    }

    public boolean isRegisterShutdownHook() {
        return this.registerShutdownHook.get();
    }

    public void setRegisterShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook.set(registerShutdownHook);
    }

    public void disableShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    public boolean isQuietMode() {
        return this.quietMode.get();
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode.set(quietMode);
        if (quietMode) {
            System.setOut(new NullPrintStream());
        } else {
            System.setOut(this.savedSystemOut);
        }
    }

    public boolean isStrippedMode() {
        return this.strippedMode.get();
    }

    public void setStrippedMode(boolean strippedMode) {
        this.strippedMode.set(strippedMode);
    }

    public void setConfigDirty(boolean configDirty) {
        this.configDirty.set(configDirty);
    }

    public void saveConfigIfDirty() {
        if (this.configDirty.get()) {
            this.logSwiftlet.logInformation("SwiftletManager", "Configuration was updated, saving ...");
            this.saveConfiguration();
        }
    }

    public String getLastSwiftlet() {
        return this.kernelSwiftletNames[this.kernelSwiftletNames.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExtensionSwiftlet(Bundle bundle) throws Exception {
        this.lock.writeLock().lock();
        try {
            String name = bundle.getBundleName();
            this.trace("loadExtensionSwiftlet: '" + name + "' ...");
            this.bundleTable.put(bundle.getBundleName(), bundle);
            Swiftlet swiftlet = this.loadSwiftlet(name);
            swiftlet.setName(name);
            long startupTime = -1L;
            Configuration config = this.getConfiguration(swiftlet);
            RouterConfiguration.Singleton().addEntity(config);
            config.setExtension(true);
            this.trace("Swiftlet: '" + name + "', startUpSwiftlet ...");
            this.startUpSwiftlet(swiftlet, config);
            startupTime = System.currentTimeMillis();
            swiftlet.setStartupTime(startupTime);
            this.swiftletTable.put(name, swiftlet);
            swiftlet = null;
            this.saveConfiguration();
            this.trace("loadExtensionSwiftlet: '" + name + "' DONE.");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadExtensionSwiftlet(Bundle bundle) {
        this.lock.writeLock().lock();
        try {
            String name = bundle.getBundleName();
            this.trace("unloadExtensionSwiftlet: '" + name + "' ...");
            try {
                Swiftlet swiftlet = this.swiftletTable.get(name);
                if (swiftlet != null) {
                    this.shutdownSwiftlet(swiftlet);
                }
                RouterConfiguration.Singleton().removeEntity(RouterConfiguration.Singleton().getEntity(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bundleTable.remove(name);
            this.swiftletTable.remove(name);
            System.gc();
            System.runFinalization();
            this.trace("unloadExtensionSwiftlet: '" + name + "' DONE.");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isUseSmartTree() {
        return this.smartTree.get();
    }

    public boolean isStartup() {
        return this.startup.get();
    }

    public boolean isRebooting() {
        return this.rebooting.get();
    }

    protected Map<String, Bundle> createBundleTable(String kernelPath) throws Exception {
        if (kernelPath == null) {
            throw new Exception("Missing attribute: kernelpath");
        }
        File f = new File(SwiftUtilities.addWorkingDir(kernelPath));
        if (!f.exists() || !f.isDirectory()) {
            throw new Exception("Invalid value for 'kernelpath': directory doesn't exists");
        }
        if (this.dp == null) {
            this.dp = new DeployPath(f, true, this.getClass().getClassLoader());
        } else {
            boolean reuseCL = Boolean.valueOf(System.getProperty(PROP_REUSE_KERNEL_CL, "false"));
            if (reuseCL) {
                this.dp.init();
            } else {
                this.dp = new DeployPath(f, true, this.getClass().getClassLoader());
            }
        }
        BundleEvent[] events = this.dp.getBundleEvents();
        if (events == null) {
            throw new Exception("No Kernel Swiftlets found in 'kernelpath'");
        }
        HashMap<String, Bundle> table = new HashMap<String, Bundle>();
        for (BundleEvent event : events) {
            Bundle b = event.getBundle();
            table.put(b.getBundleName(), b);
        }
        return table;
    }

    private Document getInitialConfig() throws Exception {
        String initialConfig = System.getProperty(PROP_INITIAL_CONFIG);
        if (initialConfig != null && initialConfig.trim().length() > 0) {
            return XMLUtilities.createDocument(new FileInputStream(initialConfig));
        }
        return this.routerConfig.get();
    }

    private void checkAndApplyPreconfig() throws Exception {
        String preconfig = System.getProperty(PROP_PRECONFIG);
        if (preconfig != null && preconfig.trim().length() > 0) {
            StringTokenizer t = new StringTokenizer(preconfig, ",");
            while (t.hasMoreTokens()) {
                String pc = t.nextToken();
                XMLUtilities.writeDocument(this.routerConfig.get(), String.valueOf(this.configFilename) + fmt.format(new Date()));
                this.routerConfig.set(new PreConfigurator(this.routerConfig.get(), XMLUtilities.createDocument(new FileInputStream(pc))).applyChanges());
                XMLUtilities.writeDocument(this.routerConfig.get(), this.configFilename.get());
                System.out.println("Applied changes from preconfig file: " + pc);
            }
        }
    }

    public void startRouter(String name) throws Exception {
        if (!this.workingDirAdded.get()) {
            this.configFilename.set(SwiftUtilities.addWorkingDir(name));
            this.workingDirAdded.set(true);
        }
        this.routerConfig.set(XMLUtilities.createDocument(new FileInputStream(this.configFilename.get())));
        UpgradeUtilities.checkRelease(this.configFilename.get(), this.routerConfig.get());
        this.checkAndApplyPreconfig();
        Element root = this.routerConfig.get().getRootElement();
        this.parseOptionalConfiguration(root);
        String value = root.attributeValue("startorder");
        if (value == null) {
            throw new Exception("Missing attribute: startorder");
        }
        StringTokenizer t = new StringTokenizer(value, " ,:");
        this.kernelSwiftletNames = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            this.kernelSwiftletNames[i++] = t.nextToken();
        }
        if (root.attributeValue("use-smart-tree") != null) {
            this.smartTree.set(Boolean.parseBoolean(root.attributeValue("use-smart-tree")));
        } else {
            this.smartTree.set(true);
        }
        if (root.attributeValue("memory-collect-interval") != null) {
            this.memCollectInterval.set(Long.valueOf(root.attributeValue("memory-collect-interval")));
        }
        this.routerName.set(root.attributeValue("name"));
        this.bundleTable = this.createBundleTable(root.attributeValue("kernelpath"));
        this.initSwiftlets();
        this.timerSwiftlet = (TimerSwiftlet)this.getSwiftlet("sys$timer");
        if (PROP_CONFIG_WATCHDOG_INTERVAL > 0L) {
            this.configfileWatchdog = new ConfigfileWatchdog(this.traceSpace, this.logSwiftlet, this.configFilename.get());
            this.timerSwiftlet.addTimerListener(PROP_CONFIG_WATCHDOG_INTERVAL, this.configfileWatchdog);
        }
        if (this.shutdownHook == null && this.registerShutdownHook.get()) {
            this.shutdownHook = new Thread(() -> this.shutdown());
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void parseOptionalConfiguration(Element root) {
    }

    protected void createRouterCommands() {
        RouterConfiguration.Singleton().setName(this.getRouterName());
        RouterConfiguration.Singleton().createCommands();
        CommandRegistry commandRegistry = new CommandRegistry("current Router's Swiftlet Manager", null);
        RouterConfiguration.Singleton().setCommandRegistry(commandRegistry);
        CommandExecutor rebootExecutor = (context, entity, cmd) -> {
            if (cmd.length != 1) {
                return new String[]{"Error:", "Invalid command, please try 'reboot'"};
            }
            String[] result = new String[]{"Information:", "Reboot Launch in 10 Seconds."};
            Thread t = new Thread(Thread.currentThread().getThreadGroup().getParent(), "Reboot Thread"){

                @Override
                public void run() {
                    SwiftletManager.this.reboot(10000L);
                }
            };
            t.setDaemon(false);
            t.setPriority(1);
            t.start();
            return result;
        };
        Command rebootCommand = new Command("reboot", "reboot", "Reboot the Router", true, rebootExecutor, true, false);
        commandRegistry.addCommand(rebootCommand);
        CommandExecutor haltExecutor = (context, entity, cmd) -> {
            if (cmd.length != 1) {
                return new String[]{"Error:", "Invalid command, please try 'halt'"};
            }
            String[] result = new String[]{"Information:", "Router Halt in 10 Seconds."};
            Thread t = new Thread(Thread.currentThread().getThreadGroup().getParent(), "Halt Thread"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwiftletManager.this.shutdown(true);
                    System.exit(0);
                }
            };
            t.setDaemon(false);
            t.start();
            t.setPriority(1);
            return result;
        };
        Command haltCommand = new Command("halt", "halt", "Halt the Router", true, haltExecutor, true, false);
        commandRegistry.addCommand(haltCommand);
        CommandExecutor saveExecutor = (context, entity, cmd) -> {
            if (cmd.length > 1) {
                return new String[]{"Error:", "Invalid command, please try 'save'"};
            }
            String[] result = null;
            result = this.saveConfiguration(RouterConfiguration.Singleton());
            return result;
        };
        Command saveCommand = new Command("save", "save", "Save this Router Configuration", true, saveExecutor, true, false);
        commandRegistry.addCommand(saveCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSwiftlets() {
        this.lock.writeLock().lock();
        try {
            System.out.println("Booting SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] ...");
            this.startup.set(true);
            this.swiftletTable = new ConcurrentHashMapWithNulls<String, Swiftlet>();
            this.createRouterCommands();
            try {
                Entity envEntity = new Entity(".env", "Router Environment", "Environment of this Router", null);
                envEntity.createCommands();
                RouterConfiguration.Singleton().addEntity(envEntity);
                Property prop = new Property("routername");
                prop.setType(String.class);
                prop.setDisplayName("Router Name");
                prop.setDescription("Name of this Router");
                prop.setValue(this.getRouterName());
                prop.setRebootRequired(true);
                prop.setPropertyChangeListener(new PropertyChangeAdapter(null){

                    @Override
                    public void propertyChanged(Property property, Object oldValue, Object newValue) throws PropertyChangeException {
                        try {
                            if (newValue != null) {
                                SwiftUtilities.verifyRouterName((String)newValue);
                            }
                        }
                        catch (Exception e) {
                            throw new PropertyChangeException(e.getMessage());
                        }
                    }
                });
                envEntity.addProperty(prop.getName(), prop);
                prop = new Property("use-smart-tree");
                prop.setType(Boolean.class);
                prop.setDisplayName("Use Smart Management Tree");
                prop.setDescription("Use Smart Management Tree (reduced Usage Parts)");
                prop.setValue(this.smartTree.get());
                prop.setRebootRequired(true);
                envEntity.addProperty(prop.getName(), prop);
                prop = new Property("release");
                prop.setType(String.class);
                prop.setDisplayName("SwiftMQ Release");
                prop.setDescription("SwiftMQ Release");
                prop.setValue(Version.getKernelVersion());
                prop.setReadOnly(true);
                prop.setStorable(false);
                envEntity.addProperty(prop.getName(), prop);
                prop = new Property("hostname");
                prop.setType(String.class);
                prop.setDisplayName("Hostname");
                prop.setDescription("Router's DNS Hostname");
                String localhost = "unknown";
                try {
                    localhost = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                }
                catch (UnknownHostException e) {
                    System.err.println("Unable to determine local host name: " + String.valueOf(e));
                }
                prop.setValue(localhost);
                prop.setReadOnly(true);
                prop.setStorable(false);
                envEntity.addProperty(prop.getName(), prop);
                prop = new Property("startuptime");
                prop.setType(String.class);
                prop.setDisplayName("Startup Time");
                prop.setDescription("Router's Startup Time");
                prop.setValue(new Date().toString());
                prop.setReadOnly(true);
                prop.setStorable(false);
                envEntity.addProperty(prop.getName(), prop);
                prop = new Property("os");
                prop.setType(String.class);
                prop.setDisplayName("Operating System");
                prop.setDescription("Router's Host OS");
                prop.setValue(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " ");
                prop.setReadOnly(true);
                prop.setStorable(false);
                envEntity.addProperty(prop.getName(), prop);
                prop = new Property("jre");
                prop.setType(String.class);
                prop.setDisplayName("JRE");
                prop.setDescription("JRE Version");
                prop.setValue(System.getProperty("java.version"));
                prop.setReadOnly(true);
                prop.setStorable(false);
                envEntity.addProperty(prop.getName(), prop);
                prop = new Property("memory-collect-interval");
                prop.setType(Long.class);
                prop.setDisplayName("Memory Collect Interval");
                prop.setDescription("Memory Collect Interval (ms)");
                prop.setValue(this.memCollectInterval.get());
                prop.setReadOnly(false);
                prop.setStorable(false);
                envEntity.addProperty(prop.getName(), prop);
                this.memoryMeter = new RouterMemoryMeter(prop);
                envEntity.addEntity(this.memoryMeter.getMemoryList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fillSwiftletTable();
            this.startKernelSwiftlets();
            this.trace("Init swiftlets successful");
            this.memoryMeter.start();
            this.startup.set(false);
            if (this.doFireKernelStartedEvent.get()) {
                this.fireKernelStartedEvent();
            }
            this.logSwiftlet.logInformation("SwiftletManager", "networkaddress.cache.ttl=" + Security.getProperty("networkaddress.cache.ttl"));
            System.out.println("SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] is ready.");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void reboot() {
        new Thread(() -> this.reboot(0L)).start();
    }

    public void reboot(long delay) {
        if (this.rebooting.get()) {
            return;
        }
        this.rebooting.set(true);
        try {
            Thread.sleep(delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shutdown();
        System.gc();
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.startRouter(this.configFilename.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.rebooting.set(false);
    }

    protected Swiftlet loadSwiftlet(String swiftletName) throws Exception {
        Bundle bundle = this.bundleTable.get(swiftletName);
        if (bundle == null) {
            throw new Exception("No bundle found for Swiftlet '" + swiftletName + "'");
        }
        Document doc = XMLUtilities.createDocument(bundle.getBundleConfig());
        String className = doc.getRootElement().attributeValue("class");
        if (className == null) {
            throw new Exception("Missing Attribute 'class' for Swiftlet '" + swiftletName + "'");
        }
        return (Swiftlet)bundle.getBundleLoader().loadClass(className).newInstance();
    }

    public Swiftlet getSwiftlet(String swiftletName) {
        Swiftlet swiftlet = null;
        swiftlet = this.swiftletTable.get(swiftletName);
        if (swiftlet != null && swiftlet.getState() == 0 && swiftlet.isKernel()) {
            return swiftlet;
        }
        return null;
    }

    Swiftlet _getSwiftlet(String swiftletName) {
        Swiftlet swiftlet = null;
        swiftlet = this.swiftletTable.get(swiftletName);
        if (swiftlet != null && swiftlet.getState() == 0) {
            return swiftlet;
        }
        return null;
    }

    public final int getSwiftletState(String swiftletName) throws UnknownSwiftletException {
        Swiftlet swiftlet = null;
        swiftlet = this.swiftletTable.get(swiftletName);
        if (swiftlet == null) {
            throw new UnknownSwiftletException("Swiftlet '" + swiftletName + "' is unknown");
        }
        return swiftlet.getState();
    }

    public final boolean isSwiftletDefined(String swiftletName) {
        return this.swiftletTable.containsKey(swiftletName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllSwiftlets() {
        this.lock.readLock().lock();
        try {
            this.trace("stopAllSwiftlets");
            ArrayList<Swiftlet> al = new ArrayList<Swiftlet>();
            for (Map.Entry o : RouterConfiguration.Singleton().getConfigurations().entrySet()) {
                String name;
                Swiftlet swiftlet;
                Configuration conf;
                Entity entity = (Entity)o.getValue();
                if (!(entity instanceof Configuration) || !(conf = (Configuration)entity).isExtension() || (swiftlet = this.swiftletTable.get(name = conf.getName())) == null || swiftlet.getState() != 0) continue;
                al.add(swiftlet);
            }
            Iterator iterator = al.iterator();
            while (iterator.hasNext()) {
                Swiftlet anAl;
                Swiftlet swiftlet = anAl = (Swiftlet)((Object)iterator.next());
                this.trace("stopAllSwiftlets: Stopping swiftlet '" + swiftlet.getName() + "'");
                try {
                    this.shutdownSwiftlet(swiftlet);
                }
                catch (SwiftletException swiftletException) {
                    // empty catch block
                }
                swiftlet.setStartupTime(-1L);
                this.trace("stopAllSwiftlets: Swiftlet " + swiftlet.getName() + " has been stopped");
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void shutdown(boolean removeShutdownHook) {
        if (removeShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.shutdown();
    }

    public void shutdown() {
        this.lock.writeLock().lock();
        try {
            System.out.println("Shutdown SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] ...");
            this.trace("shutdown");
            this.saveConfigIfDirty();
            if (this.configfileWatchdog != null) {
                this.timerSwiftlet.removeTimerListener(this.configfileWatchdog);
            }
            this.memoryMeter.close();
            this.stopAllSwiftlets();
            this.stopKernelSwiftlets();
            this.listeners.clear();
            this.allListeners.clear();
            this.kernelListeners.clear();
            this.swiftletTable.clear();
            RouterConfiguration.removeInstance();
            PoolManager.reset();
            this.traceSpace = null;
            this.logSwiftlet = null;
            System.out.println("Shutdown SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] DONE.");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getRouterName() {
        return this.routerName.get();
    }

    public void saveConfiguration() {
        this.lock.writeLock().lock();
        try {
            this.saveConfiguration(RouterConfiguration.Singleton());
            this.configDirty.set(false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected Element[] getOptionalElements() {
        return null;
    }

    protected String[] saveConfiguration(RouterConfigInstance entity) {
        ArrayList<Object> al = new ArrayList<Object>();
        al.add("Information:");
        try {
            String backupFile = String.valueOf(this.configFilename) + fmt.format(new Date());
            File file = new File(this.configFilename.get());
            file.renameTo(new File(backupFile));
            new NumberBackupFileReducer(file.getParent(), file.getName() + ".", 15).process();
            al.add("Configuration backed up to file '" + backupFile + "'.");
        }
        catch (Exception e) {
            al.add("Error creating configuration backup: " + String.valueOf(e));
        }
        try {
            Element[] optional;
            long l;
            Document doc = DocumentHelper.createDocument();
            doc.addComment("  SwiftMQ Configuration. Last Save Time: " + String.valueOf(new Date()) + "  ");
            Element root = DocumentHelper.createElement((String)"router");
            root.addAttribute("name", (String)entity.getEntity(".env").getProperty("routername").getValue());
            root.addAttribute("kernelpath", this.routerConfig.get().getRootElement().attributeValue("kernelpath"));
            root.addAttribute("release", Version.getKernelConfigRelease());
            root.addAttribute("startorder", this.routerConfig.get().getRootElement().attributeValue("startorder"));
            boolean b = (Boolean)entity.getEntity(".env").getProperty("use-smart-tree").getValue();
            if (!b) {
                root.addAttribute("use-smart-tree", "false");
            }
            if ((l = ((Long)entity.getEntity(".env").getProperty("memory-collect-interval").getValue()).longValue()) != 10000L) {
                root.addAttribute("memory-collect-interval", String.valueOf(l));
            }
            if ((optional = this.getOptionalElements()) != null) {
                for (Element anOptional : optional) {
                    XMLUtilities.elementToXML(anOptional, root);
                }
            }
            doc.setRootElement(root);
            Map configs = entity.getEntities();
            for (Object o : configs.keySet()) {
                Entity c = (Entity)configs.get((String)o);
                if (!(c instanceof Configuration)) continue;
                XMLUtilities.configToXML((Configuration)c, root);
            }
            XMLUtilities.writeDocument(doc, this.configFilename.get());
            al.add("Configuration saved to file '" + String.valueOf(this.configFilename) + "'.");
        }
        catch (Exception e) {
            al.add("Error saving configuration: " + String.valueOf(e));
        }
        return al.toArray(new String[al.size()]);
    }

    private Configuration getConfigurationTemplate(String swiftletName) throws Exception {
        Bundle bundle = this.bundleTable.get(swiftletName);
        if (bundle == null) {
            return null;
        }
        Configuration c = XMLUtilities.createConfigurationTemplate(bundle.getBundleConfig());
        XMLUtilities.loadIcons(c, bundle.getBundleLoader());
        return c;
    }

    private Configuration fillConfiguration(Configuration template) throws Exception {
        return XMLUtilities.fillConfiguration(template, this.routerConfig.get());
    }

    Configuration fillConfigurationFromTemplate(String swiftletName, Document routerConfigDoc) throws Exception {
        Bundle bundle = this.bundleTable.get(swiftletName);
        if (bundle == null) {
            return null;
        }
        Configuration template = XMLUtilities.createConfigurationTemplate(bundle.getBundleConfig());
        return XMLUtilities.fillConfiguration(template, routerConfigDoc);
    }

    public void addSurviveData(String key, Object data) {
        this.surviveMap.put(key, data);
    }

    public void removeSurviveData(String key) {
        this.surviveMap.remove(key);
    }

    public Object getSurviveData(String key) {
        return this.surviveMap.get(key);
    }

    public final void addSwiftletManagerListener(String swiftletName, SwiftletManagerListener l) {
        this.trace("addSwiftletManagerListener: Swiftlet " + swiftletName + "', adding SwiftletManagerListener");
        HashSet<SwiftletManagerListener> qListeners = this.listeners.get(swiftletName);
        if (qListeners == null) {
            qListeners = new HashSet();
            this.listeners.put(swiftletName, qListeners);
        }
        qListeners.add(l);
    }

    public final void addSwiftletManagerListener(SwiftletManagerListener l) {
        this.trace("addSwiftletManagerListener: adding SwiftletManagerListener");
        this.allListeners.add(l);
    }

    public final void removeSwiftletManagerListener(String swiftletName, SwiftletManagerListener l) {
        this.trace("removeSwiftletManagerListener: Swiftlet " + swiftletName + "', removing SwiftletManagerListener");
        HashSet<SwiftletManagerListener> qListeners = this.listeners.get(swiftletName);
        if (qListeners != null) {
            qListeners.remove(l);
            if (qListeners.isEmpty()) {
                this.listeners.put(swiftletName, null);
            }
        }
    }

    public final void removeSwiftletManagerListener(SwiftletManagerListener l) {
        this.trace("removeSwiftletManagerListener: removing SwiftletManagerListener");
        this.allListeners.remove(l);
    }

    public final void addKernelStartupListener(KernelStartupListener l) {
        this.trace("addKernelStartupListener: adding KernelStartupListener");
        this.kernelListeners.add(l);
    }

    public final void removeKernelStartupListener(KernelStartupListener l) {
        this.trace("removeKernelStartupListener: removing KernelStartupListener");
        this.kernelListeners.remove(l);
    }

    protected void fireKernelStartedEvent() {
        this.trace("fireKernelStartedEvent");
        Set cloned = null;
        cloned = (Set)((HashSet)this.kernelListeners).clone();
        for (KernelStartupListener aCloned : cloned) {
            aCloned.kernelStarted();
        }
    }

    protected void fireSwiftletManagerEvent(String swiftletName, String methodName, SwiftletManagerEvent evt) {
        this.trace("fireSwiftletManagerEvent: Swiftlet " + swiftletName + "', method: " + methodName);
        Set qListeners = this.listeners.get(swiftletName);
        if (qListeners != null) {
            this.notifyListeners(qListeners, methodName, evt);
        }
        this.notifyListeners(this.allListeners, methodName, evt);
    }

    private void notifyListeners(Set<SwiftletManagerListener> listeners, String methodName, SwiftletManagerEvent evt) {
        for (SwiftletManagerListener listener : listeners) {
            switch (methodName) {
                case "swiftletStartInitiated": {
                    listener.swiftletStartInitiated(evt);
                    break;
                }
                case "swiftletStarted": {
                    listener.swiftletStarted(evt);
                    break;
                }
                case "swiftletStopInitiated": {
                    listener.swiftletStopInitiated(evt);
                    break;
                }
                case "swiftletStopped": {
                    listener.swiftletStopped(evt);
                }
            }
        }
    }

    private class SwiftletShutdown
    implements Runnable {
        Swiftlet swiftlet = null;
        SwiftletException exception = null;

        public SwiftletShutdown(Swiftlet swiftlet) {
            this.swiftlet = swiftlet;
        }

        public SwiftletException getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                if (this.swiftlet.isKernel()) {
                    SwiftletManager.this.trace("Swiftlet " + this.swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStopInitiated");
                    SwiftletManager.this.fireSwiftletManagerEvent(this.swiftlet.getName(), "swiftletStopInitiated", new SwiftletManagerEvent(SwiftletManager.this, this.swiftlet.getName()));
                    SwiftletManager.this.trace("Swiftlet " + this.swiftlet.getName() + "', swiftlet.shutdown()");
                }
                this.swiftlet.shutdown();
                this.swiftlet.setState(1);
                if (this.swiftlet.isKernel()) {
                    SwiftletManager.this.trace("Swiftlet " + this.swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStopped");
                    SwiftletManager.this.fireSwiftletManagerEvent(this.swiftlet.getName(), "swiftletStopped", new SwiftletManagerEvent(SwiftletManager.this, this.swiftlet.getName()));
                }
            }
            catch (SwiftletException e) {
                this.exception = e;
            }
        }
    }

    public class ConcurrentHashMapWithNulls<K, V>
    extends ConcurrentHashMap<K, V> {
        private final Object NULL_PLACEHOLDER = new Object();

        @Override
        public V put(K key, V value) {
            return (V)(value == null ? super.put(key, this.NULL_PLACEHOLDER) : super.put(key, value));
        }

        @Override
        public V get(Object key) {
            Object value = super.get(key);
            return value == this.NULL_PLACEHOLDER ? null : (V)value;
        }
    }
}

