/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.auth;

import com.swiftmq.swiftlet.auth.ResourceLimitException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ResourceLimitGroup {
    String name = null;
    final AtomicInteger maxConnections = new AtomicInteger();
    final AtomicInteger maxSessions = new AtomicInteger();
    final AtomicInteger maxTempQueues = new AtomicInteger();
    final AtomicInteger maxProducers = new AtomicInteger();
    final AtomicInteger maxConsumers = new AtomicInteger();
    final AtomicInteger sessions = new AtomicInteger();
    final AtomicInteger tempQueues = new AtomicInteger();
    final AtomicInteger producers = new AtomicInteger();
    final AtomicInteger consumers = new AtomicInteger();
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ResourceLimitGroup(String name, int maxConnections, int maxSessions, int maxTempQueues, int maxProducers, int maxConsumers) {
        this.name = name;
        this.maxConnections.set(maxConnections);
        this.maxSessions.set(maxSessions);
        this.maxTempQueues.set(maxTempQueues);
        this.maxProducers.set(maxProducers);
        this.maxConsumers.set(maxConsumers);
    }

    public String getName() {
        return this.name;
    }

    public int getMaxConnections() {
        return this.maxConnections.get();
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections.set(maxConnections);
    }

    public void verifyConnectionLimit(int n) throws ResourceLimitException {
        this.lock.readLock().lock();
        try {
            if (this.maxConnections.get() != -1 && n >= this.maxConnections.get()) {
                throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max connections exceeded. Resource limit is: " + String.valueOf(this.maxConnections));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getMaxSessions() {
        return this.maxSessions.get();
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions.set(maxSessions);
    }

    public int getMaxTempQueues() {
        return this.maxTempQueues.get();
    }

    public void setMaxTempQueues(int maxTempQueues) {
        this.maxTempQueues.set(maxTempQueues);
    }

    public int getMaxProducers() {
        return this.maxProducers.get();
    }

    public void setMaxProducers(int maxProducers) {
        this.maxProducers.set(maxProducers);
    }

    public int getMaxConsumers() {
        return this.maxConsumers.get();
    }

    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers.set(maxConsumers);
    }

    public void incSessions() throws ResourceLimitException {
        this.lock.writeLock().lock();
        try {
            if (this.sessions.get() >= this.maxSessions.get()) {
                throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max sessions per connection exceeded. Resource limit is: " + String.valueOf(this.maxSessions));
            }
            this.sessions.getAndIncrement();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void decSessions() {
        this.lock.writeLock().lock();
        try {
            this.sessions.getAndDecrement();
            if (this.sessions.get() < 0) {
                this.sessions.set(0);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getSessions() {
        return this.sessions.get();
    }

    public void incTempQueues() throws ResourceLimitException {
        this.lock.writeLock().lock();
        try {
            if (this.tempQueues.get() >= this.maxTempQueues.get()) {
                throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max temp. queues per connection exceeded. Resource limit is: " + String.valueOf(this.maxTempQueues));
            }
            this.tempQueues.getAndIncrement();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void decTempQueues() {
        this.lock.writeLock().lock();
        try {
            this.tempQueues.getAndDecrement();
            if (this.tempQueues.get() < 0) {
                this.tempQueues.set(0);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getTempQueues() {
        return this.tempQueues.get();
    }

    public void incProducers() throws ResourceLimitException {
        this.lock.writeLock().lock();
        try {
            if (this.producers.get() >= this.maxProducers.get()) {
                throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max producers per connection exceeded. Resource limit is: " + String.valueOf(this.maxProducers));
            }
            this.producers.getAndIncrement();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void decProducers() {
        this.lock.writeLock().lock();
        try {
            this.producers.getAndDecrement();
            if (this.producers.get() < 0) {
                this.producers.set(0);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getProducers() {
        return this.producers.get();
    }

    public void incConsumers() throws ResourceLimitException {
        this.lock.writeLock().lock();
        try {
            if (this.consumers.get() >= this.maxConsumers.get()) {
                throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max consumers per connection exceeded. Resource limit is: " + String.valueOf(this.maxConsumers));
            }
            this.consumers.getAndIncrement();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void decConsumers() {
        this.lock.writeLock().lock();
        try {
            this.consumers.getAndDecrement();
            if (this.consumers.get() < 0) {
                this.consumers.set(0);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getConsumers() {
        return this.consumers.get();
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[ResourceLimitGroup ");
        b.append(this.name);
        b.append(", maxConnections=");
        b.append(this.maxConnections.get());
        b.append(", maxSessions=");
        b.append(this.maxSessions.get());
        b.append(", sessions=");
        b.append(this.sessions.get());
        b.append(", maxTempQueues=");
        b.append(this.maxTempQueues.get());
        b.append(", tempQueues=");
        b.append(this.tempQueues.get());
        b.append(", maxProducers=");
        b.append(this.maxProducers.get());
        b.append(", producers=");
        b.append(this.producers.get());
        b.append(", maxConsumers=");
        b.append(this.maxConsumers.get());
        b.append(", consumers=");
        b.append(this.consumers.get());
        b.append("]");
        return b.toString();
    }
}

