/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class FlowController {
    protected final AtomicInteger receiverCount = new AtomicInteger();
    protected final AtomicInteger queueSize = new AtomicInteger();
    protected final AtomicLong lastDelay = new AtomicLong();
    protected final AtomicLong sentCount = new AtomicLong();
    protected final AtomicLong sentCountCalls = new AtomicLong();
    protected final AtomicLong receiveCount = new AtomicLong();
    protected final AtomicLong receiveCountCalls = new AtomicLong();
    protected final AtomicLong timestamp = new AtomicLong();

    public int getStartQueueSize() {
        return 0;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize.set(queueSize);
    }

    public void setReceiverCount(int count) {
        if (count == 0) {
            this.sentCount.set(0L);
            this.sentCountCalls.set(0L);
            this.receiveCount.set(0L);
            this.receiveCountCalls.set(0L);
            this.timestamp.set(0L);
        } else if (this.receiverCount.get() == 0 && count > 0) {
            this.timestamp.set(System.currentTimeMillis());
            this.sentCount.set(this.queueSize.get());
            this.sentCountCalls.set(this.queueSize.get());
        }
        this.receiverCount.set(count);
    }

    public void setReceiveMessageCount(int count) {
        if (this.timestamp.get() != 0L) {
            this.receiveCount.addAndGet(count);
            this.receiveCountCalls.getAndIncrement();
        }
    }

    public void setSentMessageCount(int count) {
        if (this.timestamp.get() != 0L) {
            this.sentCount.addAndGet(count);
            this.sentCountCalls.getAndIncrement();
        }
    }

    public long getLastDelay() {
        return this.lastDelay.get();
    }

    public abstract long getNewDelay();

    public String toString() {
        StringBuffer b = new StringBuffer("[FlowController, ");
        b.append("timestamp=");
        b.append(this.timestamp.get());
        b.append(", receiveCount=");
        b.append(this.receiveCount.get());
        b.append(", receiveCountCalls=");
        b.append(this.receiveCountCalls.get());
        b.append(", sentCount=");
        b.append(this.sentCount.get());
        b.append(", sentCountCalls=");
        b.append(this.sentCountCalls.get());
        b.append("]");
        return b.toString();
    }
}

