/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.ToClientSerializer;
import com.swiftmq.swiftlet.queue.MessageIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MessageEntry {
    MessageIndex messageIndex;
    MessageImpl message;
    transient int connectionId = -1;

    public MessageEntry() {
        this(null, null);
    }

    public MessageEntry(MessageIndex messageIndex, MessageImpl message) {
        this.messageIndex = messageIndex;
        this.message = message;
    }

    public MessageIndex getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(MessageIndex messageIndex) {
        this.messageIndex = messageIndex;
    }

    public MessageImpl getMessage() {
        return this.message;
    }

    public void setMessage(MessageImpl message) {
        this.message = message;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    public void moveMessageAttributes() {
        try {
            this.message.setIntProperty("JMSXDeliveryCount", this.messageIndex.getDeliveryCount());
            this.message.setJMSRedelivered(this.messageIndex.getDeliveryCount() > 1);
            this.message.setMessageIndex(this.messageIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeContent(ToClientSerializer serializer) throws IOException {
        this.messageIndex.writeContent(serializer.getDataOutput());
        this.message.writeContent(serializer);
    }

    public void writeContent(DataOutput out) throws IOException {
        this.messageIndex.writeContent(out);
        this.message.writeContent(out);
    }

    public void readContent(DataInput in) throws IOException {
        this.messageIndex = new MessageIndex();
        this.messageIndex.readContent(in);
        this.message = MessageImpl.createInstance(in.readInt());
        this.message.readContent(in);
    }

    public String toString() {
        return "[MessageEntry, messageIndex=" + String.valueOf(this.messageIndex) + ", message=" + String.valueOf(this.message) + ", connectionId=" + this.connectionId + "]";
    }
}

