/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MessageIndex
implements Comparable {
    long id;
    int priority;
    int deliveryCount;
    int txId = -1;
    int hashCode = 0;

    public MessageIndex() {
        this(-1L, -1, -1);
    }

    public MessageIndex(long id, int priority, int deliveryCount) {
        this.priority = priority;
        this.id = id;
        this.deliveryCount = deliveryCount;
        this.newHashCode();
    }

    private void newHashCode() {
        this.hashCode = (int)(this.id ^ this.id >>> 32);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
        this.newHashCode();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public int getTxId() {
        return this.txId;
    }

    public void setTxId(int txId) {
        this.txId = txId;
    }

    public boolean equals(Object obj) {
        MessageIndex that = (MessageIndex)obj;
        return that.priority == this.priority && that.id == this.id;
    }

    public int compareTo(Object obj) {
        MessageIndex that = (MessageIndex)obj;
        if (this.priority < that.priority) {
            return -1;
        }
        if (this.priority == that.priority) {
            if (this.id < that.id) {
                return -1;
            }
            if (this.id == that.id) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void writeContent(DataOutput out) throws IOException {
        out.writeInt(this.priority);
        out.writeLong(this.id);
        out.writeInt(this.deliveryCount);
        out.writeInt(this.txId);
    }

    public void readContent(DataInput in) throws IOException {
        this.priority = in.readInt();
        this.id = in.readLong();
        this.deliveryCount = in.readInt();
        this.txId = in.readInt();
    }

    public String toString() {
        return this.priority + "_" + this.id;
    }
}

