/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.swiftlet.queue.QueueOutputStream;
import com.swiftmq.swiftlet.queue.QueuePullTransaction;
import com.swiftmq.swiftlet.queue.QueueReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;

public class QueueInputStream
extends InputStream {
    QueueReceiver queueReceiver = null;
    QueuePullTransaction transaction = null;
    BytesMessageImpl currentMsg = null;
    int actSize = -1;
    int count = 0;
    int actSeq = -1;
    boolean eof = false;
    long receiveTimeout = -1L;
    int windowSize = 10;
    SortedSet messageCache = null;

    public QueueInputStream(QueueReceiver queueReceiver, long receiveTimeout, int windowSize) {
        this.queueReceiver = queueReceiver;
        this.receiveTimeout = receiveTimeout;
        this.windowSize = windowSize;
        this.messageCache = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    int i1 = ((BytesMessageImpl)o1).getIntProperty(QueueOutputStream.SEQNO);
                    int i2 = ((BytesMessageImpl)o2).getIntProperty(QueueOutputStream.SEQNO);
                    return i1 == i2 ? 0 : (i1 < i2 ? -1 : 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }

            @Override
            public boolean equals(Object that) {
                return false;
            }
        });
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public Enumeration getMsgPropNames() throws Exception {
        if (this.currentMsg == null) {
            return null;
        }
        return this.currentMsg.getPropertyNames();
    }

    public Object getMsgProp(String key) throws Exception {
        if (this.currentMsg == null) {
            return null;
        }
        return this.currentMsg.getObjectProperty(key);
    }

    private boolean isEOF(BytesMessageImpl msg) {
        try {
            boolean b = msg.getBooleanProperty(QueueOutputStream.EOF);
            return b;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void ensureNextMsgInSequence() throws IOException {
        int seqNo;
        if (this.currentMsg != null && (this.count < this.actSize || this.eof)) {
            return;
        }
        this.currentMsg = null;
        if (this.messageCache.size() > 0) {
            try {
                MessageEntry me = (MessageEntry)this.messageCache.first();
                BytesMessageImpl msg = (BytesMessageImpl)me.message;
                seqNo = msg.getIntProperty(QueueOutputStream.SEQNO);
                if (seqNo == this.actSeq + 1) {
                    this.currentMsg = msg;
                    this.actSeq = seqNo;
                    this.actSize = msg.getIntProperty(QueueOutputStream.SIZE);
                    this.eof = this.isEOF(msg);
                    this.count = 0;
                    this.messageCache.remove(msg);
                    return;
                }
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        while (this.currentMsg == null && this.messageCache.size() < this.windowSize) {
            try {
                this.transaction = this.queueReceiver.createTransaction(false);
                BytesMessageImpl msg = null;
                MessageEntry me = null;
                me = this.receiveTimeout > 0L ? this.transaction.getMessage(this.receiveTimeout) : this.transaction.getMessage();
                msg = (BytesMessageImpl)me.message;
                msg.reset();
                seqNo = msg.getIntProperty(QueueOutputStream.SEQNO);
                if (seqNo == this.actSeq + 1) {
                    this.currentMsg = msg;
                    this.actSeq = seqNo;
                    this.actSize = msg.getIntProperty(QueueOutputStream.SIZE);
                    this.eof = this.isEOF(msg);
                    this.count = 0;
                } else {
                    this.messageCache.add(msg);
                }
                this.transaction.commit();
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
    }

    @Override
    public int read() throws IOException {
        int b;
        this.ensureNextMsgInSequence();
        if (this.eof && this.count >= this.actSize) {
            return -1;
        }
        try {
            b = this.currentMsg.readByte() & 0xFF;
            ++this.count;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return b;
    }

    @Override
    public int available() throws IOException {
        if (this.currentMsg == null) {
            return 0;
        }
        return this.actSize - this.count;
    }

    @Override
    public void close() throws IOException {
        this.messageCache.clear();
        if (this.transaction != null) {
            try {
                this.transaction.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

