/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.XidImpl;
import com.swiftmq.swiftlet.queue.AbstractQueue;
import com.swiftmq.swiftlet.queue.FlowController;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.QueueTransaction;
import com.swiftmq.swiftlet.queue.QueueTransactionClosedException;
import com.swiftmq.swiftlet.queue.QueueTransactionHandler;
import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import java.util.concurrent.atomic.AtomicInteger;

public class QueuePushTransaction
extends QueueTransaction {
    AtomicInteger size = new AtomicInteger(0);

    QueuePushTransaction(AbstractQueue abstractQueue, Object transactionId, QueueTransactionHandler queueTransactionHandler) {
        super(abstractQueue, transactionId, queueTransactionHandler);
    }

    public QueuePushTransaction() {
    }

    @Override
    void restart(AbstractQueue abstractQueue, Object transactionId, QueueTransactionHandler queueTransactionHandler) {
        super.restart(abstractQueue, transactionId, queueTransactionHandler);
        this.size.set(0);
    }

    public long getFlowControlDelay() {
        FlowController fc = this.abstractQueue.getFlowController();
        return fc == null ? 0L : fc.getNewDelay();
    }

    public boolean hasReceiver(MessageImpl message) {
        return this.abstractQueue.hasReceiver(message);
    }

    public boolean hasSpaceLeft() {
        int maxMessages = this.abstractQueue.getMaxMessages();
        boolean rc = false;
        try {
            rc = maxMessages <= 0 || (long)this.size.get() + this.abstractQueue.getNumberQueueMessages() <= (long)maxMessages;
        }
        catch (QueueException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public void putMessage(MessageImpl message) throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.abstractQueue.putMessage(this.transactionId, message);
        this.size.incrementAndGet();
    }

    public void commit(AsyncCompletionCallback callback) {
        try {
            this.verifyTransactionState();
        }
        catch (QueueTransactionClosedException e) {
            callback.setException((Exception)((Object)e));
            callback.done(false);
            return;
        }
        this.setClosed(true);
        this.abstractQueue.commit(this.transactionId, callback);
    }

    @Override
    public void rollback(XidImpl globalTransactionId, boolean setRedelivered) throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.setClosed(true);
        this.abstractQueue.rollback(this.transactionId, globalTransactionId, false);
    }

    @Override
    public void rollback() throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.setClosed(true);
        this.abstractQueue.rollback(this.transactionId, false);
    }

    public void rollback(AsyncCompletionCallback callback) {
        try {
            this.verifyTransactionState();
        }
        catch (QueueTransactionClosedException e) {
            callback.setException((Exception)((Object)e));
            callback.done(false);
            return;
        }
        this.setClosed(true);
        this.abstractQueue.rollback(this.transactionId, false, callback);
    }
}

