/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.mgmt.EntityList;
import com.swiftmq.swiftlet.queue.ActiveQueue;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.QueueHandlerClosedException;
import com.swiftmq.swiftlet.queue.QueuePullTransaction;
import com.swiftmq.swiftlet.queue.QueueTransactionHandler;
import com.swiftmq.swiftlet.queue.Selector;
import com.swiftmq.tools.gc.Recyclable;
import com.swiftmq.tools.gc.Recycler;

public class QueueReceiver
extends QueueTransactionHandler {
    EntityList receiverEntityList = null;
    Selector selector = null;
    int viewId = -1;
    long receiverId = -1L;

    public QueueReceiver(ActiveQueue activeQueue, EntityList receiverEntityList) {
        super(activeQueue.getAbstractQueue().selectBaseQueue());
        this.setRecycler(new PullTransactionRecycler());
        this.receiverEntityList = receiverEntityList;
        this.abstractQueue.incReceiverCount();
    }

    public QueueReceiver(ActiveQueue activeQueue, EntityList receiverEntityList, Selector selector) {
        this(activeQueue, receiverEntityList);
        this.selector = selector;
        if (selector != null) {
            this.viewId = this.abstractQueue.createView(selector);
        }
    }

    public long getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(long receiverId) {
        this.receiverId = receiverId;
    }

    public QueuePullTransaction createTransaction(boolean setRedeliveredOnRollback) throws QueueException, QueueHandlerClosedException {
        this.verifyQueueHandlerState();
        QueuePullTransaction t = (QueuePullTransaction)this.recycler.checkOut();
        t.restart(this.abstractQueue, this.abstractQueue.createPullTransaction(), this, setRedeliveredOnRollback);
        t.setView(this.selector, this.viewId);
        t.setReceiverId(this.receiverId);
        return t;
    }

    @Override
    public void close() throws QueueException, QueueHandlerClosedException {
        this.abstractQueue.decReceiverCount();
        this.abstractQueue.receiverClosed(this.receiverId);
        super.close();
        if (this.receiverEntityList != null) {
            this.receiverEntityList.removeDynamicEntity(this);
            this.receiverEntityList = null;
        }
        if (this.viewId != -1) {
            this.abstractQueue.deleteView(this.viewId);
        }
        this.viewId = -1;
    }

    private class PullTransactionRecycler
    extends Recycler {
        private PullTransactionRecycler() {
        }

        @Override
        protected Recyclable createRecyclable() {
            return new QueuePullTransaction();
        }
    }
}

