/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.mgmt.EntityList;
import com.swiftmq.swiftlet.queue.ActiveQueue;
import com.swiftmq.swiftlet.queue.FlowController;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.QueueHandlerClosedException;
import com.swiftmq.swiftlet.queue.QueuePushTransaction;
import com.swiftmq.swiftlet.queue.QueueTransactionHandler;
import com.swiftmq.tools.gc.Recyclable;
import com.swiftmq.tools.gc.Recycler;

public class QueueSender
extends QueueTransactionHandler {
    EntityList senderEntityList = null;

    public QueueSender(ActiveQueue activeQueue, EntityList senderEntityList) {
        super(activeQueue.getAbstractQueue());
        this.setRecycler(new PushTransactionRecycler());
        this.senderEntityList = senderEntityList;
    }

    public QueuePushTransaction createTransaction() throws QueueException, QueueHandlerClosedException {
        this.verifyQueueHandlerState();
        QueuePushTransaction t = (QueuePushTransaction)this.recycler.checkOut();
        t.restart(this.abstractQueue, this.abstractQueue.createPushTransaction(), this);
        return t;
    }

    public long getFlowControlDelay() {
        FlowController fc = this.abstractQueue.getFlowController();
        return fc == null ? 0L : fc.getNewDelay();
    }

    @Override
    public void close() throws QueueException, QueueHandlerClosedException {
        super.close();
        if (this.senderEntityList != null) {
            this.senderEntityList.removeDynamicEntity(this);
            this.senderEntityList = null;
        }
    }

    private class PushTransactionRecycler
    extends Recycler {
        private PushTransactionRecycler() {
        }

        @Override
        protected Recyclable createRecyclable() {
            return new QueuePushTransaction();
        }
    }
}

