/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.swiftlet.queue.WireTapSubscriber;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WireTap {
    String name;
    List<WireTapSubscriber> subscribers = new ArrayList<WireTapSubscriber>();
    int nextSubscriber = 0;

    public WireTap(String name, WireTapSubscriber subscriber) {
        this.name = name;
        this.subscribers.add(subscriber);
    }

    public String getName() {
        return this.name;
    }

    public void addSubscriber(WireTapSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removeSubscriber(WireTapSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    public boolean hasSubscribers() {
        return this.subscribers.size() > 0;
    }

    private MessageImpl copyMessage(MessageImpl msg) {
        try {
            DataByteArrayOutputStream dbos = new DataByteArrayOutputStream();
            DataByteArrayInputStream dbis = new DataByteArrayInputStream();
            msg.writeContent(dbos);
            dbis.reset();
            dbis.setBuffer(dbos.getBuffer(), 0, dbos.getCount());
            MessageImpl msgCopy = MessageImpl.createInstance(dbis.readInt());
            msgCopy.readContent(dbis);
            return msgCopy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void putMessage(MessageImpl message) {
        WireTapSubscriber subscriber;
        if (!this.hasSubscribers()) {
            return;
        }
        if (this.nextSubscriber >= this.subscribers.size()) {
            this.nextSubscriber = 0;
        }
        if ((subscriber = this.subscribers.get(this.nextSubscriber)).isSelected(message)) {
            if (subscriber.requieresDeepCopy()) {
                subscriber.putMessage(this.copyMessage(message));
            } else {
                subscriber.putMessage(message);
            }
        }
        ++this.nextSubscriber;
    }
}

