/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.routing;

import com.swiftmq.swiftlet.Swiftlet;
import com.swiftmq.swiftlet.routing.Route;
import com.swiftmq.swiftlet.routing.event.RoutingEvent;
import com.swiftmq.swiftlet.routing.event.RoutingListener;
import com.swiftmq.tools.collection.ConcurrentList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RoutingSwiftlet
extends Swiftlet {
    private final Map<String, Route> routingTable = new ConcurrentHashMap<String, Route>();
    private final List<RoutingListener> listeners = new ConcurrentList<RoutingListener>(new ArrayList());

    public Route getRoute(String destination) {
        return this.routingTable.get(destination);
    }

    public Route[] getRoutes() {
        Route[] routes = new Route[this.routingTable.size()];
        int i = 0;
        for (Route route : this.routingTable.values()) {
            routes[i++] = route;
        }
        return routes;
    }

    protected void addRoute(Route route) {
        this.routingTable.put(route.getDestination(), route);
        this.fireRoutingEvent("destinationAdded", new RoutingEvent(this, route.getDestination()));
    }

    protected void removeRoute(Route route) {
        this.routingTable.remove(route.getDestination());
        this.fireRoutingEvent("destinationRemoved", new RoutingEvent(this, route.getDestination()));
    }

    protected void removeAllRoutes() {
        for (Route route : this.routingTable.values()) {
            this.removeRoute(route);
        }
    }

    public void addRoutingListener(RoutingListener l) {
        this.listeners.add(l);
    }

    public void removeRoutingListener(RoutingListener l) {
        this.listeners.remove(l);
    }

    protected void removeAllRoutingListeners() {
        this.listeners.clear();
    }

    public void fireRoutingEvent(String method, RoutingEvent evt) {
        for (RoutingListener l : this.listeners) {
            switch (method) {
                case "destinationAdded": {
                    l.destinationAdded(evt);
                    break;
                }
                case "destinationRemoved": {
                    l.destinationRemoved(evt);
                    break;
                }
                case "destinationActivated": {
                    l.destinationActivated(evt);
                    break;
                }
                case "destinationDeactivated": {
                    l.destinationDeactivated(evt);
                }
            }
        }
    }
}

