/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.topic;

import com.swiftmq.jms.TopicImpl;
import com.swiftmq.swiftlet.Swiftlet;
import com.swiftmq.swiftlet.auth.ActiveLogin;
import com.swiftmq.swiftlet.auth.AuthenticationException;
import com.swiftmq.swiftlet.queue.QueueAlreadyDefinedException;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.Selector;
import com.swiftmq.swiftlet.queue.UnknownQueueException;
import com.swiftmq.swiftlet.topic.TopicException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import java.util.StringTokenizer;

public abstract class TopicManager
extends Swiftlet {
    protected abstract String getTopicQueuePrefix();

    protected abstract String getTopicDelimiter();

    public abstract void createTopic(String var1) throws TopicException;

    public abstract void deleteTopic(String var1) throws TopicException;

    public abstract boolean isTopicDefined(String var1);

    public abstract TopicImpl verifyTopic(TopicImpl var1) throws JMSException, InvalidDestinationException;

    public String getQueueForTopic(String topicName) {
        String[] names = this.tokenizeTopicName(topicName, this.getTopicDelimiter());
        String name = null;
        if (names != null && names.length > 0) {
            name = this.getTopicQueuePrefix() + names[0];
        }
        return name;
    }

    public String[] tokenizeTopicName(String topicName, String delimiter) {
        StringTokenizer t = new StringTokenizer(topicName, delimiter);
        String[] rarr = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            rarr[i++] = t.nextToken();
        }
        return rarr;
    }

    public String[] tokenizeTopicName(String topicName) {
        return this.tokenizeTopicName(topicName, this.getTopicDelimiter());
    }

    public int subscribe(String topicName, Selector selector, boolean noLocal, String queueName) throws AuthenticationException {
        TopicImpl topic = new TopicImpl(this.getQueueForTopic(topicName), topicName);
        return this.subscribe(topic, selector, noLocal, queueName, null);
    }

    public int subscribe(String topicName, Selector selector, boolean noLocal, String queueName, boolean forceCopy) throws AuthenticationException {
        TopicImpl topic = new TopicImpl(this.getQueueForTopic(topicName), topicName);
        return this.subscribe(topic, selector, noLocal, queueName, null, forceCopy);
    }

    public int subscribe(String topicName, Selector selector, boolean noLocal, String queueName, ActiveLogin activeLogin) throws AuthenticationException {
        TopicImpl topic = new TopicImpl(this.getQueueForTopic(topicName), topicName);
        return this.subscribe(topic, selector, noLocal, queueName, activeLogin);
    }

    public abstract int subscribe(TopicImpl var1, Selector var2, boolean var3, String var4, ActiveLogin var5) throws AuthenticationException;

    public abstract int subscribe(TopicImpl var1, Selector var2, boolean var3, String var4, ActiveLogin var5, boolean var6) throws AuthenticationException;

    public abstract String subscribeDurable(String var1, TopicImpl var2, Selector var3, boolean var4, ActiveLogin var5) throws AuthenticationException, QueueException, QueueAlreadyDefinedException, UnknownQueueException, TopicException;

    public abstract void deleteDurable(String var1, ActiveLogin var2) throws InvalidDestinationException, QueueException, UnknownQueueException, TopicException;

    public abstract String getDurableTopicName(String var1, ActiveLogin var2);

    public abstract void unsubscribe(int var1);

    public abstract String[] getTopicNames();
}

