/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.trace;

import com.swiftmq.swiftlet.Swiftlet;
import com.swiftmq.swiftlet.SwiftletException;
import com.swiftmq.swiftlet.trace.TraceSpace;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TraceSwiftlet
extends Swiftlet {
    public static final String SPACE_KERNEL = "kernel";
    public static final String SPACE_SWIFTLET = "swiftlet";
    public static final String SPACE_QUEUE = "queue";
    public static final String SPACE_PROTOCOL = "protocol";
    private final Map<String, TraceSpace> traceSpaces = new ConcurrentHashMap<String, TraceSpace>();

    public TraceSpace getTraceSpace(String spaceName) {
        TraceSpace existing;
        TraceSpace space = this.traceSpaces.get(spaceName);
        if (space == null && (existing = this.traceSpaces.putIfAbsent(spaceName, space = this.createTraceSpace(spaceName))) != null) {
            space = existing;
        }
        return space;
    }

    public void setTraceEnabled(String spaceName, boolean b) {
        TraceSpace space = this.getTraceSpace(spaceName);
        space.enabled = b;
    }

    protected abstract TraceSpace createTraceSpace(String var1);

    @Override
    protected void shutdown() throws SwiftletException {
        this.traceSpaces.clear();
    }
}

