/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import com.swiftmq.tools.gc.ObjectRecycler;

public class BucketTable {
    static final int DEFAULT_BUCKET_SIZE = 256;
    static final int DEFAULT_RECYCLE_SIZE = 2048;
    int bucketSize = 0;
    int recycleSize = 0;
    Bucket[] buckets = null;
    BucketRecycler recycler = null;
    int elements = 0;

    public BucketTable(int bucketSize, int recycleSize) {
        this.bucketSize = bucketSize;
        this.recycleSize = recycleSize;
        this.buckets = new Bucket[bucketSize];
        this.recycler = new BucketRecycler(recycleSize);
    }

    public BucketTable() {
        this(256, 2048);
    }

    private Bucket getBucket(int bidx) {
        if (bidx >= this.buckets.length) {
            Bucket[] b = new Bucket[Math.max(this.buckets.length + this.bucketSize, bidx + this.bucketSize)];
            System.arraycopy(this.buckets, 0, b, 0, this.buckets.length);
            this.buckets = b;
        }
        if (this.buckets[bidx] == null) {
            this.buckets[bidx] = (Bucket)this.recycler.checkOut();
        }
        return this.buckets[bidx];
    }

    public void set(int index, Object obj) {
        int bidx = index / this.bucketSize;
        int eidx = index - bidx * this.bucketSize;
        Bucket bucket = this.getBucket(bidx);
        bucket.array[eidx] = obj;
        ++bucket.count;
        if (obj != null) {
            ++this.elements;
        }
    }

    public Object get(int index) {
        int bidx = index / this.bucketSize;
        int eidx = index - bidx * this.bucketSize;
        Bucket bucket = this.getBucket(bidx);
        return bucket.array[eidx];
    }

    public void remove(int index) {
        int bidx = index / this.bucketSize;
        int eidx = index - bidx * this.bucketSize;
        Bucket bucket = this.getBucket(bidx);
        bucket.array[eidx] = null;
        --bucket.count;
        if (bucket.count == 0) {
            this.recycler.checkIn(bucket);
            this.buckets[bidx] = null;
        }
        --this.elements;
    }

    public int getElements() {
        return this.elements;
    }

    public int getSize() {
        return this.buckets.length * this.bucketSize;
    }

    public void clear() {
        this.recycler.clear();
        this.buckets = null;
    }

    private class Bucket {
        Object[] array = null;
        int count = 0;

        private Bucket() {
        }
    }

    private class BucketRecycler
    extends ObjectRecycler {
        public BucketRecycler(int maxSize) {
            super(maxSize);
        }

        @Override
        protected Object createRecyclable() {
            Bucket bucket = new Bucket();
            bucket.array = new Object[BucketTable.this.bucketSize];
            return bucket;
        }
    }
}

