/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import com.swiftmq.tools.collection.ExpandableList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentExpandableList<T>
extends ExpandableList<T> {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    @Override
    public int add(T element) {
        this.rwLock.writeLock().lock();
        try {
            int n = super.add(element);
            return n;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public T get(int index) {
        this.rwLock.readLock().lock();
        try {
            Object t = super.get(index);
            return t;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void remove(int index) {
        this.rwLock.writeLock().lock();
        try {
            super.remove(index);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public int indexOf(T element) {
        this.rwLock.readLock().lock();
        try {
            int n = super.indexOf(element);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.rwLock.readLock().lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.rwLock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

