/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentList<E>
implements List<E> {
    private final List<E> list;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentList(List<E> list) {
        this.list = list;
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.readLock().lock();
        try {
            Iterator<E> iterator = new ArrayList<E>(this.list).iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.readLock().lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.add(e);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.remove(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.list.containsAll(c);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.addAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.addAll(index, c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.removeAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.retainAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.list.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E get(int index) {
        this.lock.readLock().lock();
        try {
            E e = this.list.get(index);
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.lock.writeLock().lock();
        try {
            E e = this.list.set(index, element);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        this.lock.writeLock().lock();
        try {
            this.list.add(index, element);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E remove(int index) {
        this.lock.writeLock().lock();
        try {
            E e = this.list.remove(index);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int n = this.list.indexOf(o);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int n = this.list.lastIndexOf(o);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException("ListIterator not supported in ConcurrentList.");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("ListIterator not supported in ConcurrentList.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.lock.readLock().lock();
        try {
            ArrayList<E> arrayList = new ArrayList<E>(this.list.subList(fromIndex, toIndex));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

