/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import com.swiftmq.tools.collection.OrderedSet;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentOrderedSet
extends OrderedSet {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentOrderedSet(int max) {
        super(max);
    }

    @Override
    public boolean add(Object o) {
        this.lock.writeLock().lock();
        try {
            boolean bl = super.add(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void addAll(Collection<Object> c) {
        this.lock.writeLock().lock();
        try {
            super.addAll(c);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            boolean bl = super.remove(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            boolean bl = super.contains(o);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void increaseSize(int extend) {
        this.lock.writeLock().lock();
        try {
            super.increaseSize(extend);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void decreaseSize(int reduce, int minSize) {
        this.lock.writeLock().lock();
        try {
            super.decreaseSize(reduce, minSize);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void resize(int newSize) {
        this.lock.writeLock().lock();
        try {
            super.resize(newSize);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

