/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ExpandableList<T> {
    protected final List<T> list = new ArrayList<T>();
    protected final Queue<Integer> freeIndexes = new LinkedList<Integer>();

    public int add(T element) {
        Integer freeIndex = this.freeIndexes.poll();
        if (freeIndex != null) {
            this.list.set(freeIndex, element);
        } else {
            freeIndex = this.list.size();
            this.list.add(element);
        }
        return freeIndex;
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public void remove(int index) {
        this.list.set(index, null);
        this.freeIndexes.offer(index);
    }

    public int indexOf(T element) {
        return this.list.indexOf(element);
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
        this.freeIndexes.clear();
    }
}

