/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ListSet {
    List list = new LinkedList();
    Set set = new HashSet();
    int max = 0;

    public ListSet(int max) {
        this.max = max;
    }

    public void resize(int newSize) {
        while (this.list.size() > 0 && this.list.size() > newSize) {
            Object first = this.list.remove(0);
            this.set.remove(first);
        }
        this.max = newSize;
    }

    public void add(Object o) {
        if (this.set.contains(o)) {
            return;
        }
        if (this.list.size() == this.max) {
            Object first = this.list.remove(0);
            this.set.remove(first);
        }
        this.list.add(o);
        this.set.add(o);
    }

    public ListIterator forwardIterator() {
        return this.list.listIterator();
    }

    public ListIterator backwardIterator() {
        return this.list.listIterator(this.list.size());
    }

    public void addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    public void removeAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.remove(iter.next());
        }
    }

    public boolean remove(Object o) {
        this.list.remove(o);
        return this.set.remove(o);
    }

    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    public int size() {
        return this.set.size();
    }

    public int getMax() {
        return this.max;
    }

    public void clear() {
        this.list.clear();
        this.set.clear();
    }
}

