/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

public class LongRingBuffer {
    private long[] elements;
    private int first = 0;
    private int size = 0;
    private int extendSize = 32;

    public LongRingBuffer(int extendSize) {
        this.extendSize = extendSize;
        this.elements = new long[extendSize];
    }

    public LongRingBuffer(LongRingBuffer base) {
        this.extendSize = base.extendSize;
        this.first = base.first;
        this.size = base.size;
        this.elements = new long[base.extendSize];
        System.arraycopy(base.elements, 0, this.elements, 0, base.elements.length);
    }

    public void add(long obj) {
        if (this.size == this.elements.length) {
            int newSize = this.elements.length + this.extendSize;
            long[] newElements = new long[newSize];
            int n = this.elements.length - this.first;
            System.arraycopy(this.elements, this.first, newElements, 0, n);
            if (this.first != 0) {
                System.arraycopy(this.elements, 0, newElements, n, this.first);
            }
            this.elements = newElements;
            this.first = 0;
        }
        this.elements[(this.first + this.size) % this.elements.length] = obj;
        ++this.size;
    }

    public long remove() {
        long obj = this.elements[this.first];
        ++this.first;
        --this.size;
        if (this.first == this.elements.length) {
            this.first = 0;
        }
        return obj;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.first = 0;
        this.size = 0;
    }
}

