/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class OrderedSet {
    private final Set<Object> set = new LinkedHashSet<Object>();
    private int max;

    public OrderedSet(int max) {
        this.max = max;
    }

    public void increaseSize(int extend) {
        this.max += extend;
    }

    public void decreaseSize(int reduce, int minSize) {
        this.max = Math.max(minSize, this.max - reduce);
        this.reduceToSIze(this.max);
    }

    public void resize(int newSize) {
        if (newSize > this.max) {
            this.max = newSize;
        } else if (newSize < this.max) {
            this.reduceToSIze(newSize);
        }
    }

    private void reduceToSIze(int newSize) {
        Iterator<Object> iterator = this.set.iterator();
        while (this.set.size() > newSize && iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean add(Object o) {
        if (!this.set.add(o)) {
            return true;
        }
        if (this.set.size() > this.max) {
            Object first = this.set.iterator().next();
            this.set.remove(first);
        }
        return false;
    }

    public void addAll(Collection<Object> c) {
        for (Object o : c) {
            this.add(o);
        }
    }

    public Set<Object> getSet() {
        return this.set;
    }

    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    public int size() {
        return this.set.size();
    }

    public int getMax() {
        return this.max;
    }

    public void clear() {
        this.set.clear();
    }
}

