/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

public class RingBuffer {
    private Object[] elements;
    private int first = 0;
    private int size = 0;
    private int extendSize = 32;

    public RingBuffer(int extendSize) {
        this.extendSize = extendSize;
        this.elements = new Object[extendSize];
    }

    public RingBuffer(RingBuffer base) {
        this.extendSize = base.extendSize;
        this.first = base.first;
        this.size = base.size;
        this.elements = new Object[base.elements.length];
        System.arraycopy(base.elements, 0, this.elements, 0, base.elements.length);
    }

    public void add(Object obj) {
        if (this.size == this.elements.length) {
            int newSize = this.elements.length + this.extendSize;
            Object[] newElements = new Object[newSize];
            int n = this.elements.length - this.first;
            System.arraycopy(this.elements, this.first, newElements, 0, n);
            if (this.first != 0) {
                System.arraycopy(this.elements, 0, newElements, n, this.first);
            }
            this.elements = newElements;
            this.first = 0;
        }
        this.elements[(this.first + this.size) % this.elements.length] = obj;
        ++this.size;
    }

    public Object remove() {
        if (this.size == 0) {
            return null;
        }
        Object obj = this.elements[this.first];
        this.elements[this.first] = null;
        ++this.first;
        --this.size;
        if (this.first == this.elements.length) {
            this.first = 0;
        }
        return obj;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = null;
        }
        this.first = 0;
        this.size = 0;
    }
}

