/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import com.swiftmq.tools.collection.RingBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RingBufferThreadsafe
extends RingBuffer {
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RingBufferThreadsafe(int extendSize) {
        super(extendSize);
    }

    @Override
    public void add(Object obj) {
        this.lock.writeLock().lock();
        try {
            super.add(obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Object remove() {
        this.lock.writeLock().lock();
        try {
            Object object = super.remove();
            return object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getSize() {
        this.lock.readLock().lock();
        try {
            int n = super.getSize();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

