/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;

public class SortedDupsCollection
extends AbstractCollection
implements Iterator {
    SortedSet baseSet;
    int nElements = 0;
    Iterator baseIter = null;
    Entry lastIterEntry = null;
    int lastIterEntryPos = 0;

    public SortedDupsCollection(SortedSet baseSet) {
        this.baseSet = baseSet;
        this.nElements = baseSet.size();
    }

    @Override
    public boolean add(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException("Object is not instance of Comparable!");
        }
        Entry newEntry = new Entry((Comparable)o);
        Entry oldEntry = null;
        for (Entry entry : this.baseSet) {
            if (!entry.equals(newEntry)) continue;
            oldEntry = entry;
            break;
        }
        if (oldEntry != null) {
            oldEntry.add(newEntry.get(0));
            newEntry.removeAll();
        } else {
            this.baseSet.add(newEntry);
        }
        ++this.nElements;
        return true;
    }

    public Object first() {
        Entry entry = (Entry)this.baseSet.first();
        if (entry != null) {
            return entry.get(0);
        }
        return null;
    }

    @Override
    public Iterator iterator() {
        this.baseIter = this.baseSet.iterator();
        this.lastIterEntry = null;
        this.lastIterEntryPos = 0;
        return this;
    }

    @Override
    public int size() {
        return this.nElements;
    }

    @Override
    public boolean hasNext() {
        return this.baseIter.hasNext() || this.lastIterEntry != null && this.lastIterEntryPos < this.lastIterEntry.getSize();
    }

    public Object next() {
        Comparable rObj = null;
        if (this.lastIterEntry == null) {
            this.lastIterEntry = (Entry)this.baseIter.next();
        }
        if (this.lastIterEntryPos < this.lastIterEntry.getSize()) {
            rObj = this.lastIterEntry.get(this.lastIterEntryPos++);
        } else {
            this.lastIterEntry = (Entry)this.baseIter.next();
            this.lastIterEntryPos = 0;
            rObj = this.lastIterEntry.get(this.lastIterEntryPos++);
        }
        return rObj;
    }

    @Override
    public void remove() {
        if (this.lastIterEntry != null) {
            this.lastIterEntry.remove(--this.lastIterEntryPos);
            if (this.lastIterEntry.getSize() == 0) {
                this.baseIter.remove();
                this.lastIterEntry = null;
                this.lastIterEntryPos = 0;
            }
            --this.nElements;
        }
    }

    private class Entry
    implements Comparable {
        ArrayList subEntries = new ArrayList();

        Entry(Comparable first) {
            this.subEntries.add(first);
        }

        void add(Comparable newSubEntry) {
            this.subEntries.add(newSubEntry);
        }

        int getSize() {
            return this.subEntries.size();
        }

        Comparable get(int index) {
            return (Comparable)this.subEntries.get(index);
        }

        void remove(int index) {
            this.subEntries.remove(index);
        }

        void removeAll() {
            this.subEntries.clear();
        }

        public boolean equals(Object that) {
            return this.compareTo(that) == 0;
        }

        public int compareTo(Object that) {
            return ((Comparable)this.subEntries.get(0)).compareTo(((Entry)that).get(0));
        }
    }
}

