/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.concurrent;

import java.util.concurrent.atomic.AtomicReference;

public class AtomicWrappingCounterInteger {
    private final AtomicReference<Integer> counter;
    private final int initialValue;
    private final int maxValue;

    public AtomicWrappingCounterInteger(int initialValue) {
        this(initialValue, Integer.MAX_VALUE);
    }

    public AtomicWrappingCounterInteger(int initialValue, int maxValue) {
        this.initialValue = initialValue;
        this.maxValue = maxValue;
        this.counter = new AtomicReference<Integer>(initialValue);
    }

    public int get() {
        return this.counter.get();
    }

    public int getAndIncrement() {
        return this.counter.getAndUpdate(current -> current == this.maxValue ? this.initialValue : current + 1);
    }

    public void reset() {
        this.counter.set(this.initialValue);
    }
}

